# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a special QextScintilla lexer to handle the preferences.
"""

import sys

from qtext import QextScintillaLexer, QextScintilla
from qt import *

import Preferences

class PreferencesLexer(QextScintillaLexer):
    """ 
    Subclass of QextScintillaLexer to implement preferences specific lexer methods.
    """
    def __init__(self, language, parent=None, name=None):
        """
        Constructor
        
        @param language The lexer language. (string or QString)
        @param parent The parent widget of this lexer. (QextScintilla)
        @param name The name of this dialog. (QString)
        """
        QextScintillaLexer.__init__(self, parent, name)
        
        # instantiate a lexer object for the given language
        language = unicode(language)
        if language == 'Python':
            from QScintilla.LexerPython import LexerPython
            self.lex = LexerPython(self)
            if Preferences.getEditor("PythonAutoIndent"):
                self.lex.setAutoIndentStyle(0)
            else:
                self.lex.setAutoIndentStyle(QextScintilla.AiMaintain)
        elif language == 'C++':
            from QScintilla.LexerCPP import LexerCPP
            self.lex = LexerCPP(self)
            self.lex.setAutoIndentStyle(0)
        elif language == 'C#':
            from QScintilla.LexerCSharp import LexerCSharp
            self.lex = LexerCSharp(self)
            self.lex.setAutoIndentStyle(0)
        elif language == 'IDL':
            from QScintilla.LexerIDL import LexerIDL
            self.lex = LexerIDL(self)
            self.lex.setAutoIndentStyle(0)
        elif language == 'Java':
            from QScintilla.LexerJava import LexerJava
            self.lex = LexerJava(self)
            self.lex.setAutoIndentStyle(0)
        elif language == 'JavaScript':
            from QScintilla.LexerJavaScript import LexerJavaScript
            self.lex = LexerJavaScript(self)
            self.lex.setAutoIndentStyle(0)
        elif language == 'HTML':
            from QScintilla.LexerHTML import LexerHTML
            self.lex = LexerHTML(self)
            self.lex.setAutoIndentStyle(QextScintilla.AiMaintain)
        elif language == 'SQL':
            from QScintilla.LexerSQL import LexerSQL
            self.lex = LexerSQL(self)
            self.lex.setAutoIndentStyle(QextScintilla.AiMaintain)
        elif language == 'Perl':
            from QScintilla.LexerPerl import LexerPerl
            self.lex = LexerPerl(self)
            self.lex.setAutoIndentStyle(0)
        elif language == 'Bash':
            from QScintilla.LexerBash import LexerBash
            self.lex = LexerBash(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "Ruby":
            from QScintilla.LexerRuby import LexerRuby
            self.lex = LexerRuby(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "Lua":
            from QScintilla.LexerLua import LexerLua
            self.lex = LexerLua(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "CSS":
            from QScintilla.LexerCSS import LexerCSS
            self.lex = LexerCSS(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "Diff":
            from QScintilla.LexerDiff import LexerDiff
            self.lex = LexerDiff(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "Makefile":
            from QScintilla.LexerMakefile import LexerMakefile
            self.lex = LexerMakefile(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "Properties":
            from QScintilla.LexerProperties import LexerProperties
            self.lex = LexerProperties(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "TeX":
            from QScintilla.LexerTeX import LexerTeX
            self.lex = LexerTeX(self)
            self.lex.setAutoIndentStyle(0)
        elif language == "Batch":
            from QScintilla.LexerBatch import LexerBatch
            self.lex = LexerBatch(self)
            self.lex.setAutoIndentStyle(0)
        else:
            raise RuntimeError, \
                'Unsupported Lexer Language: %s' % language
        
        # define the local store
        self.colours = {}
        self.papers = {}
        self.eolFills = {}
        self.fonts = {}
        self.ind2style = {}
        self.styles = QStringList()
        
        # fill local store with default values from lexer
        # and built up styles list and conversion table from index to style
        index = 0
        for i in range(128):
            desc = self.lex.description(i)
            if not desc.isEmpty():
                self.styles.append(desc)
                
                self.colours[i] = self.lex.color(i)
                self.papers[i] = self.lex.paper(i)
                self.eolFills[i] = self.lex.eolFill(i)
                self.fonts[i] = self.lex.font(i)
                
                self.ind2style[index] = i
                index += 1
            
        # read the last stored values from preferences file
        self.readSettings(Preferences.Prefs.settings, "/eric3/Scintilla")
        
    def color(self, style):
        """
        Reimplemented method to get the colour of a style.
        
        @param style the style number (int)
        @return colour
        """
        return self.colours[style]
        
    def setColor(self, c, style):
        """
        Reimplemented method to set the colour for a style.
        
        @param c coulor (int)
        @param style the style number (int)
        """
        self.colours[style] = QColor(c)
        
    def paper(self, style):
        """
        Reimplemented method to get the background for a style.
        
        @param style the style number (int)
        @return colour
        """
        return self.papers[style]
        
    def setPaper(self, c, style):
        """
        Reimplemented method to set the background for a style.
        
        @param c coulor (int)
        @param style the style number (int)
        """
        self.papers[style] = QColor(c)
        
    def eolFill(self, style):
        """
        Reimplemented method to get the eolFill flag for a style.
        
        @param style the style number (int)
        @return eolFill flag
        """
        return self.eolFills[style]
        
    def setEolFill(self, eolfill, style):
        """
        Reimplemented method to set the eolFill flag for a style.
        
        @param eolfill eolFill flag (boolean)
        @param style the style number (int)
        """
        self.eolFills[style] = eolfill
        
    def font(self, style):
        """
        Reimplemented method to get the font for a style.
        
        @param style the style number (int)
        @return font
        """
        return self.fonts[style]
        
    def setFont(self, f, style):
        """
        Reimplemented method to set the font for a style.
        
        @param f font
        @param style the style number (int)
        """
        self.fonts[style] = QFont(f)
        
    def language(self):
        """
        Public method to get the lexers programming language.
        
        @return language
        """
        return self.lex.language()
        
    def lexer(self):
        """
        Public method to get the lexers name.
        
        @return lexer name
        """
        return self.lex.lexer()
        
    def getLexer(self):
        """
        Public method to get a reference to the underlying lexer object.
        
        @return reference to the lexer
        """
        return self.lex
        
    def description(self, style):
        """
        Public method to get a descriptive string for a style.
        
        @param tyle the style number (int)
        @return description of the style (QString)
        """
        return self.lex.description(style)
        
# some test code
if __name__ == '__main__':
    lex = PreferencesLexer('Python')
    print "lexer done"
    lex.writeSettings(Preferences.Prefs.settings, '/eric3/Scintilla')
    print "written"
