#ifndef __READ_H__
#define __READ_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

typedef enum {
        COMPLETE_NONE,
        COMPLETE_FILES,
        COMPLETE_FUNS,
        COMPLETE_ADDRS
} complete_mode_t;

typedef enum {
        HIDE_NO,
        HIDE_ASTERISK,
        HIDE_EMPTY
} hide_mode_t;

/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

/** abort reading input */
extern void read_abort (void);
/** accept the input */
extern void read_accept (void);
/** move forward a character */
extern void read_forward_char (void);
/** move back a character */
extern void read_backward_char (void);
/** move forward over a word */
extern void read_forward_word (void);
/** move back over a word */
extern void read_backward_word (void);
/** move to the start of the line */
extern void read_begin (void);
/** move to the end of the line */
extern void read_end (void);
/** delete the character at point */
extern void read_del_char_fwd (void);
/** delete the character behind the cursor */
extern void read_del_char_back (void);
/** delete the word after the point */
extern void read_del_word_fwd (void);
/** delete the word behind the cursor */
extern void read_del_word_back (void);
/** kill the text from point to the end of the line */
extern void read_kill_line (void);
/** attempt to perform completion on the text before point */
extern void read_complete (void);
/** move to the first completion */
extern void read_choose_first (void);
/** move to the last completion */
extern void read_choose_last (void);
/** move on to the next completion */
extern void read_choose_next (void);
/** move to the previous completion */
extern void read_choose_prev (void);

extern void  read_prepare (const char *prompt, const char *def,
                           complete_mode_t mode, hide_mode_t hide);
extern void  read_restore (void);
extern void  read_put_char (int c);
extern void  read_echo_input (void);
extern char *read_argument (const char *prompt, const char *def,
                            complete_mode_t mode, hide_mode_t hide);
extern void  read_free_resources (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER read.h
 *
 ****************************************************************************/
#endif
