#ifndef __RADDRESS_H__
#define __RADDRESS_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "address.h"
#include "rstring.h"
#include "memchunk.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

struct raddress {
  address_t    **array;
  int         size;
  int         count;
  unsigned    flags;
};

typedef struct raddress raddress_t;

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern raddress_t *raddress_create_size (int count);
extern raddress_t *raddress_create (void);
extern void        raddress_destroy (raddress_t *ptr);
extern void        raddress_add (raddress_t *ptr, address_t *x);
extern void        raddress_remove (raddress_t *ptr, unsigned index);
extern void        raddress_shrink (raddress_t *ptr);
extern raddress_t *raddress_join (raddress_t *x, raddress_t *y);
extern void        raddress_add_array (raddress_t *x, raddress_t *y);
extern raddress_t *raddress_get_from_header (char *header);
extern rstring_t  *raddress_to_strings (raddress_t *ptr);
extern char       *raddress_list (raddress_t *ptr, const char *header,
                                  int line_break, const char *line_indent);
extern raddress_t *raddress_read (memchunk_t *chunk);
extern void        raddress_dump (raddress_t *ptr, memchunk_t *chunk);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER raddress.h
 *
 ****************************************************************************/
#endif
