//---------------------------------------------------------------------------------------
//  EDTableViewInspector.m created by erik on Mon 28-Jun-1999
//  @(#)$Id: EDTableViewInspector.m,v 2.0 2002/08/16 18:15:33 erik Exp $
//
//  Copyright (c) 1999-2000 by Erik Doernenburg. All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted, provided that both the copyright notice and this permission
//  notice appear in all copies of the software, derivative works or modified versions,
//  and any portions thereof, and that both notices appear in supporting documentation,
//  and that credit is given to Erik Doernenburg in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import <EDCommon/EDTableView.h>
#import <EDCommon/EDTVScrollView.h>
#import "EDTableViewInspector.h"

#if 0

//---------------------------------------------------------------------------------------
    @implementation EDTableViewInspector
//---------------------------------------------------------------------------------------

- (id)init
{
    self = [super init];
    [NSBundle loadNibNamed:@"EDTableViewInspector" owner:self];
    return self;
}


- (BOOL)wantsButtons
{
    return NO;
}


- (void)revert:(id)sender
{
    EDTableView		*v;
    EDTVScrollView	*sv;

    v = [self object];
    if([v isKindOfClass:[EDTVScrollView class]])
        v = [(EDTVScrollView *)v documentView];
    sv = (EDTVScrollView *)[[v superview] superview];

    [allowsMultipleSelectionButton setState:[v allowsMultipleSelection] ? NSOnState : NSOffState];
    [allowsEmptySelectionButton setState:[v allowsEmptySelection] ? NSOnState : NSOffState];
    [allowsColumnSelectionButton setState:[v allowsColumnSelection] ? NSOnState : NSOffState];

    [hasHorizontalScrollBarButton setState:[sv hasHorizontalScroller] ? NSOnState : NSOffState];
    [hasVerticalScrollBarButton setState:[sv hasVerticalScroller] ? NSOnState : NSOffState];

    [allowsReorderingColumnsButton setState:[v allowsColumnReordering]];

    [allowsDraggingRowsButton setState:[v allowsRowDragging] ? NSOnState : NSOffState];
    [allowsDraggingRowsButton setEnabled:[v allowsRowReordering] == NO];
    [allowsReorderingRowsButton setState:[v allowsRowReordering] ? NSOnState : NSOffState];
    [allowsReorderingRowsButton setEnabled:[v allowsRowDragging] == NO];
          
    [needsControlToMoveRowsButton setState:[v needsControlKeyForMove] ? NSOnState : NSOffState];
    [needsControlToMoveRowsButton setEnabled:([v allowsRowDragging] || [v allowsRowReordering])];

    [delaysRequestingDataButton setState:[v delaysRequestingData] ? NSOnState : NSOffState];
    
    [showGridButton setState:[v drawsGrid] ? NSOnState : NSOffState];
    [rowHeightCell setIntValue:[v rowHeight]];

    [super revert:sender];
}


- (void)ok:(id)sender
{
    EDTVScrollView	*sv;
    id				v;

    v = [self object];
    if([v isKindOfClass:[EDTVScrollView class]])
        v = [(EDTVScrollView *)v documentView];
    sv = (EDTVScrollView *)[[v superview] superview];

    [v setAllowsMultipleSelection:([allowsMultipleSelectionButton state] == NSOnState)];
    [v setAllowsEmptySelection:([allowsEmptySelectionButton state] == NSOnState)];
    [v setAllowsColumnSelection:([allowsColumnSelectionButton state] == NSOnState)];

    [sv setHasHorizontalScroller:([hasHorizontalScrollBarButton state] == NSOnState)];
    [sv setHasVerticalScroller:([hasVerticalScrollBarButton state] == NSOnState)];

    [v setAllowsColumnReordering:([allowsReorderingColumnsButton state] == NSOnState)];

    [v setAllowsRowDragging:([allowsDraggingRowsButton state] == NSOnState)];
    [v setAllowsRowReordering:([allowsReorderingRowsButton state] == NSOnState)];
    [allowsDraggingRowsButton setEnabled:[v allowsRowReordering] == NO];
    [allowsReorderingRowsButton setEnabled:[v allowsRowDragging] == NO];

    [v setNeedsControlKeyForMove:([needsControlToMoveRowsButton state] == NSOnState)];
    [needsControlToMoveRowsButton setEnabled:([v allowsRowDragging] || [v allowsRowReordering])];
    
    [v setDelaysRequestingData:([delaysRequestingDataButton state] == NSOnState)];

    [v setDrawsGrid:([showGridButton state] == NSOnState)];
    [v setRowHeight:[rowHeightCell intValue]];

    [super ok:sender];
}



//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------
    @implementation EDTableView(IBInspector)
//-------------------------------------------------------------------------------------------

- (NSString *)inspectorClassName
{
    return @"EDTableViewInspector";
}


//-------------------------------------------------------------------------------------------
    @end
//-------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------
    @implementation EDTVScrollView(IBInspector)
//-------------------------------------------------------------------------------------------

- (NSString *)inspectorClassName
{
    return @"EDTableViewInspector";
}


//-------------------------------------------------------------------------------------------
    @end
//-------------------------------------------------------------------------------------------

#endif
