//---------------------------------------------------------------------------------------
//  EDObjectWellInspector.m created by erik on Sun 11-Oct-1998
//  @(#)$Id: EDObjectWellInspector.m,v 2.0 2002/08/16 18:15:33 erik Exp $
//
//  Copyright (c) 1998-2000 by Erik Doernenburg. All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted, provided that both the copyright notice and this permission
//  notice appear in all copies of the software, derivative works or modified versions,
//  and any portions thereof, and that both notices appear in supporting documentation,
//  and that credit is given to Erik Doernenburg in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import <EDCommon/EDObjectWell.h>
#import "EDObjectWellInspector.h"


//---------------------------------------------------------------------------------------
    @implementation EDObjectWellInspector
//---------------------------------------------------------------------------------------

- (id)init
{
    self = [super init];
    [NSBundle loadNibNamed:@"EDObjectWellInspector" owner:self];
    return self;
}


- (BOOL)wantsButtons
{
    return NO;
}


- (void)revert:(id)sender
{
    [drawsBezelButton setState:([[self object] drawsBezel] ? NSOnState : NSOffState)];
    [delaysRequestingDataButton setState:([[self object] delaysRequestingData] ? NSOnState : NSOffState)];
    [super revert:sender];
}


- (void)ok:(id)sender
{
    [[self object] setDrawsBezel:([drawsBezelButton state] == NSOnState)];
    [[self object] setDelaysRequestingData:([delaysRequestingDataButton state] == NSOnState)];
    [super ok:sender];
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------


//---------------------------------------------------------------------------------------
    @implementation EDObjectWell(IBInspector)
//---------------------------------------------------------------------------------------

- (NSString *)inspectorClassName
{
    return @"EDObjectWellInspector";
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------
