//---------------------------------------------------------------------------------------
//  EDActivityIndicatorInspector.m created by erik on Tue 10-Nov-1998
//  @(#)$Id: EDActivityIndicatorInspector.m,v 2.0 2002/08/16 18:15:33 erik Exp $
//
//  Copyright (c) 1998-1999 by Erik Doernenburg. All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted, provided that both the copyright notice and this permission
//  notice appear in all copies of the software, derivative works or modified versions,
//  and any portions thereof, and that both notices appear in supporting documentation,
//  and that credit is given to Erik Doernenburg in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import <EDCommon/EDActivityIndicator.h>
#import "EDActivityIndicatorInspector.h"


//---------------------------------------------------------------------------------------
    @implementation EDActivityIndicatorInspector
//---------------------------------------------------------------------------------------

- (id)init
{
   self = [super init];
    [NSBundle loadNibNamed:@"EDActivityIndicatorInspector" owner:self];
   return self;
}


- (BOOL)wantsButtons
{
   return NO;
}


- (void)revert:(id)sender
{
    [well setColor:[[self object] backgroundColor]];
    [drawsBackgroundButton setState:([[self object] drawsBackground] ? NSOnState : NSOffState)];
    [hidesOnLoadButton setState:([[self object] hidesOnLoad] ? NSOnState : NSOffState)];
    [super revert:sender];
}


- (void)ok:(id)sender
{
    [[self object] setBackgroundColor:[well color]];
    [[self object] setDrawsBackground:([drawsBackgroundButton state] == NSOnState)];
    [[self object] setHidesOnLoad:([hidesOnLoadButton state] == NSOnState)];
    [super ok:sender];
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------


//---------------------------------------------------------------------------------------
    @implementation EDActivityIndicator(IBInspector)
//---------------------------------------------------------------------------------------

- (NSString *)inspectorClassName
{
    return @"EDActivityIndicatorInspector";
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------
