//---------------------------------------------------------------------------------------
//  EDCanvasInspector.m created by erik on Sat 31-Oct-1998
//  @(#)$Id: EDCanvasInspector.m,v 2.0 2002/08/16 18:15:33 erik Exp $
//
//  Copyright (c) 1998 by Erik Doernenburg. All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted, provided that both the copyright notice and this permission
//  notice appear in all copies of the software, derivative works or modified versions,
//  and any portions thereof, and that both notices appear in supporting documentation,
//  and that credit is given to Erik Doernenburg in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------

#import <AppKit/AppKit.h>
#import <EDCommon/EDCanvas.h>
#import "EDCanvasInspector.h"


//---------------------------------------------------------------------------------------
    @implementation EDCanvasInspector
//---------------------------------------------------------------------------------------

- (id)init
{
   self = [super init];
   [NSBundle loadNibNamed:@"EDCanvasInspector" owner:self];
   return self;
}


- (BOOL)wantsButtons
{
   return NO;
}


- (void)revert:(id)sender
{
    // [[NSColorPanel sharedColorPanel] setShowsAlpha:YES];
    [well setColor:[[self object] color]];
    [bezelButton setState:([[self object] drawsBezel] ? NSOnState : NSOffState)];
    [super revert:sender];
}


- (void)ok:(id)sender
{
    [[self object] setColor:[well color]];
    [[self object] setDrawsBezel:([bezelButton state] == NSOnState)];
    [super ok:sender];
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------


//---------------------------------------------------------------------------------------
    @implementation EDCanvas(IBInspector)
//---------------------------------------------------------------------------------------

- (NSString *)inspectorClassName
{
    return @"EDCanvasInspector";
}


//---------------------------------------------------------------------------------------
    @end
//---------------------------------------------------------------------------------------
