
#include "vpostproc/pp_number.hh"
#include "libvideogfx/graphics/draw/draw.hh"

#include <sys/time.h>
#include <unistd.h>

#include <iostream>
using namespace std;

static int ac_s = 0*2;
static int ac_e = ac_s+15;

static char* fps_text = 
"*****  ****    ***\n"
"*      *   *  *   *\n"
"*      *   *  *      * \n"
"***    ****    ***\n"
"*      *          *  *\n"
"*      *      *   *\n"
"*      *       ***";

static char* num_text[11] = {
  " *** \n"
  "*   *\n"
  "*   *\n"
  "*   *\n"
  "*   *\n"
  "*   *\n"
  " *** \n"
  ,
  "  ** \n"
  " * * \n"
  "*  * \n"
  "   * \n"
  "   * \n"
  "   * \n"
  "   * \n"
  ,
  " *** \n"
  "*   *\n"
  "*   *\n"
  "   * \n"
  "  *  \n"
  " *   \n"
  "*****\n"
  ,
  " *** \n"
  "*   *\n"
  "    *\n"
  "  ** \n"
  "    *\n"
  "*   *\n"
  " *** \n"
  ,
  "  *  \n"
  " *   \n"
  "*  * \n"
  "*****\n"
  "   * \n"
  "   * \n"
  "   * \n"
  ,
  "*****\n"
  "*    \n"
  "*    \n"
  "**** \n"
  "    *\n"
  "*   *\n"
  " *** \n"
  ,
  " *** \n"
  "*   *\n"
  "*    \n"
  "**** \n"
  "*   *\n"
  "*   *\n"
  " *** \n"
  ,
  "*****\n"
  "    *\n"
  "   * \n"
  " ****\n"
  "  *  \n"
  "  *  \n"
  "  *  \n"
  ,
  " *** \n"
  "*   *\n"
  "*   *\n"
  " *** \n"
  "*   *\n"
  "*   *\n"
  " *** \n"
  ,
  " *** \n"
  "*   *\n"
  "*   *\n"
  " ****\n"
  "    *\n"
  "*   *\n"
  " *** \n"
  ,
  "     \n"
  "     \n"
  "     \n"
  "     \n"
  "     \n"
  " **  \n"
  " **  \n" };

VideoPostprocessor_FrameNumber::VideoPostprocessor_FrameNumber()
  : next_number(0)
{
}

VideoPostprocessor_FrameNumber::~VideoPostprocessor_FrameNumber()
{
}

inline bool VideoPostprocessor_FrameNumber::NeedsPictureData(uint3 pictype) const
{
  assert(d_next);
  return d_next->NeedsPictureData(pictype);
}

bool VideoPostprocessor_FrameNumber::NeedsMBData(uint3 pictype) const
{
  assert(d_next);
  return d_next->NeedsMBData(pictype);
}

int VideoPostprocessor_FrameNumber::Draw(const char* text,int x0,int y0,
                                         DecodedImageData* drawimg)
{
  Pixel*const* py = drawimg->m_image.AskFrameY();
  Pixel*const* pu = drawimg->m_image.AskFrameU();
  Pixel*const* pv = drawimg->m_image.AskFrameV();

  ImageParam param = drawimg->m_image.AskParam();

  int maxx=0;
  int dx=0,dy=0;
  const char* p = text;
  while (*p)
    {
      if (*p=='\n')
	{
	  dx=0; dy+=2;
	}
      else
	{
	  if (*p=='*')
	    {
	      //cout << y0+dy << "/" << y0+dy+1 << endl;
	      //ShowDIMG(drawimg);

	      Assert(drawimg->ContainsOutputLine(y0+dy));
	      Assert(drawimg->ContainsOutputLine(y0+dy+1));

	      int ypos = drawimg->GetIndexForOutputLine(y0+dy);

	      py[ypos  ][x0+dx]=py[ypos  ][x0+dx+1]=255;
	      py[ypos+1][x0+dx]=py[ypos+1][x0+dx+1]=255;

	      if (param.chroma==Chroma_420)
		{
		  pu[(ypos)/2][(x0+dx)/2]=128;
		  pv[(ypos)/2][(x0+dx)/2]=128;
		}
	      else if (param.chroma==Chroma_422)
		{
		  pu[ypos][(x0+dx)/2]=pu[ypos+1][(x0+dx)/2]=128;
		  pv[ypos][(x0+dx)/2]=pv[ypos+1][(x0+dx)/2]=128;
		}
	      else
		{
		  Assert(param.chroma==Chroma_444);

		  pu[ypos][(x0+dx)  ]=pu[ypos+1][(x0+dx)  ]=128;
		  pu[ypos][(x0+dx)+1]=pu[ypos+1][(x0+dx)+1]=128;
		  pv[ypos][(x0+dx)  ]=pv[ypos+1][(x0+dx)  ]=128;
		  pv[ypos][(x0+dx)+1]=pv[ypos+1][(x0+dx)+1]=128;
		}
	    }
	  dx+=2;

	  if (dx>maxx) maxx=dx;
	}
      p++;
    }

  return x0+maxx;
}

void VideoPostprocessor_FrameNumber::BeginPicture(const DecodedImageData* dimg)
{
  StartAccumulation(ac_s,ac_e,true);
  d_next->BeginPicture(dimg);
}

void VideoPostprocessor_FrameNumber::ShowMBRows(DecodedImageData* dimg)
{
  DecodedImageData* drawimg = Accumulate(dimg);

  if (!drawimg)
    return;

  Assert(drawimg->m_may_modify);

  ImageParam param = drawimg->m_image.AskParam();

  int x0 = 4; //param.width-2*(25 /*fps:*/ + 5*7);
  int y0 = ac_s+2; //param.height-2*(10);

  x0 &= ~1;
  y0 &= ~1;

  // draw "FPS:"

  x0=Draw(num_text[((int)(next_number/10000))%10],x0,y0,drawimg); x0+=4;
  x0=Draw(num_text[((int)(next_number/ 1000))%10],x0,y0,drawimg); x0+=4;
  x0=Draw(num_text[((int)(next_number/  100))%10],x0,y0,drawimg); x0+=4;
  x0=Draw(num_text[((int)(next_number/   10))%10],x0,y0,drawimg); x0+=4;
  x0=Draw(num_text[((int)(next_number/    1))%10],x0,y0,drawimg); x0+=4;

  next_number++;

  d_next->ShowMBRows(drawimg);
}

void VideoPostprocessor_FrameNumber::FinishedPicture()
{
  d_next->FinishedPicture();
}
