
#include "vpostproc/pp_rotate.hh"


void VideoPostprocessor_Rotate::ShowMBRows(DecodedImageData* decimg)
{
  // Accumulate image pieces until the complete image is complete.

  DecodedImageData* dimg = Accumulate(decimg);
  if (!dimg)
    { return; }


  // Get input image size

  ImageParam param = dimg->m_image.AskParam();

  const int width  = param.width;
  const int height = param.height;
  const int cw = param.AskChromaWidth();
  const int ch = param.AskChromaHeight();


  // Create new image with new size

  ImageParam spec = dimg->m_image.AskParam();
  spec.width  = param.height;
  spec.height = param.width;
  newdimg.m_image.Create(spec);

  newdimg.m_width  = height;
  newdimg.m_height = width;

  newdimg.m_src_y_start=0;
  newdimg.m_src_y_end  =newdimg.m_height-1;
  newdimg.m_dst_y_start=0;
  newdimg.m_field_lines=false;
  newdimg.m_may_modify =true;

  newdimg.m_timing = dimg->m_timing;


  // Rotate image

  Pixel*const* dpy = newdimg.m_image.AskFrameY();
  Pixel*const* dpu = newdimg.m_image.AskFrameU();
  Pixel*const* dpv = newdimg.m_image.AskFrameV();

  const Pixel*const* spy = dimg->m_image.AskFrameY();
  const Pixel*const* spu = dimg->m_image.AskFrameU();
  const Pixel*const* spv = dimg->m_image.AskFrameV();

  for (int y=0;y<height;y++)
    for (int x=0;x<width;x++)
      {
	dpy[width-1-x][y] = spy[y][x];
      }

  for (int y=0;y<ch;y++)
    for (int x=0;x<cw;x++)
      {
	dpu[cw-1-x][y] = spu[y][x];
	dpv[cw-1-x][y] = spv[y][x];
      }


  // Forward image data to next postprocessor

  d_next->ShowMBRows(&newdimg);
}


void VideoPostprocessor_Rotate::BeginPicture(const DecodedImageData* dimg)
{
  StartAccumulation(0,dimg->m_height-1,true);  // Accumulate complete picture

  d_next->BeginPicture(dimg);
}


void VideoPostprocessor_Rotate::FinishedPicture()
{
  d_next->FinishedPicture();
}
