/********************************************************************************
    Copyright (C) 2001  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "output/out_aalib.hh"
#include <stdlib.h>


VideoSink_AALib::VideoSink_AALib()
  : pic_available(false),
    d_initialized(false)
{
}


VideoSink_AALib::~VideoSink_AALib()
{
  aa_close(context);
}

void VideoSink_AALib::ShowMBRows(DecodedImageData* dimg)
{
  nextpts = dimg->m_timing.pts;

  DecodedImageData* decimg = Accumulate(dimg);
  if (!decimg)
    return;

  if (!d_initialized)
    {
      aa_parseoptions(NULL,NULL,NULL,NULL);

      context = aa_autoinit(&aa_defparams);
      if (!context)
	{ fprintf(stderr,"cannot initialize aalib\n"); exit(1); }

      aa_autoinitkbd(context,0);
      d_initialized=true;
    }

  if (aa_getevent(context,0)==AA_RESIZE)
    aa_resize(context);

  unsigned char* img = aa_image(context);

  int w = aa_imgwidth(context);
  int h = aa_imgheight(context);

  ImageParam param = decimg->m_image.AskParam();

  const int imgw = param.width;
  const int imgh = param.height;

  const Pixel*const* yp = decimg->m_image.AskFrameY();

  for (int y=0;y<h;y++)
    for (int x=0;x<w;x++)
      img[y*w+x] = yp[y*imgh/h][x*imgw/w];

  aa_render(context,&aa_defrenderparams,0,0,aa_scrwidth(context),aa_scrheight(context));
  aa_flush(context);
}

void VideoSink_AALib::BeginPicture(const DecodedImageData* dimg)
{
  StartAccumulation(0,dimg->m_height-1,false);
}

void VideoSink_AALib::FinishedPicture()
{
  pic_available=true;
}
