#!/bin/sh
#
# Copyright (c) 2002-2003 Hajimu UMEMOTO <ume@mahoroba.org>.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

# interface cloning example
tunif='gif70'

# static allocation example
#unit_min=70
#unit_max=79
#tunif='gif7[0-9]'

# YOU MUST CHANGE TO ASSIGN THIS WITHIN YOUR ADDRESS BLOCK.
#prefix='3ffe:501:185b:8000::'

#dtcps_flags='-o'

case "$1" in
start)
	if [ -n "${unit_min}" -a -n "${unit_max}" ]; then
		unit=${unit_min}
		while [ ${unit} -le ${unit_max} ]; do
			ifconfig gif${unit} create >/dev/null 2>&1
			unit=$((${unit}+1))
		done
	fi
	if [ -x /usr/local/sbin/dtcps ]; then
		echo -n ' dtcps'
		/usr/local/sbin/dtcps -i ${tunif} ${dtcps_flags} ${prefix}
	fi
	;;
stop)
	kill `cat /var/run/dtcps.pid`
	;;
restart)
	$0 stop
	$0 start
	;;
*)
	echo "Usage: `basename $0` {start|stop|restart}" >&2
	;;
esac
