<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
    "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
<!-- $Id: form.html.fr,v 1.3 2006/02/10 14:07:24 sdalu Exp $ -->
 
<!--                                                                      -->
<!-- CONTACT     : http://www.dnsdoctor.org/                              -->
<!-- AUTHOR      : Stephane D'Alu <sdalu@sdalu.com>                       -->
<!--                                                                      -->
<!-- CREATED     : 2002/10/01 13:58:17                                    -->
<!-- REVISION    : $Revision: 1.3 $                                      -->
<!-- DATE        : $Date: 2006/02/10 14:07:24 $                           -->
<!--                                                                      -->
<!-- CONTRIBUTORS: (see also CREDITS file)                                -->
<!--                                                                      -->
<!--                                                                      -->
<!-- LICENSE     : GPL v2                                                 -->
<!-- COPYRIGHT   : Stephane D'Alu (c) 2004                                -->
<!--                                                                      -->
<!-- This file is part of DNSdoctor.                                      -->
<!--                                                                      -->
<!-- DNSdoctor is free software; you can redistribute it and/or modify it -->
<!-- under the terms of the GNU General Public License as published by    -->
<!-- the Free Software Foundation; either version 2 of the License, or    -->
<!-- (at your option) any later version.                                  -->
<!--                                                                      -->
<!-- DNSdoctor is distributed in the hope that it will be useful, but     -->
<!-- WITHOUT ANY WARRANTY; without even the implied warranty of           -->
<!-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    -->
<!-- General Public License for more details.                             -->
<!--                                                                      -->
<!-- You should have received a copy of the GNU General Public License    -->
<!-- along with DNSdoctor; if not, write to the Free Software Foundation, -->
<!-- Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA          -->
<!--                                                                      -->

<html>
  <head>
    <link rel="stylesheet" href="@HTML_PATH@/style/dnsdoctor.css" type="text/css"/>
    <link rel="stylesheet" href="@HTML_PATH@/style/default.css"   type="text/css"/>
    <link rel="icon"       href="@HTML_PATH@/img/ddoc-fav.png"    type="image/png"/>

    <link rel="start" title="DNSdoctor page principale"
	  href="@HTML_PATH@/" type="text/html"/>
    <link rel="help"	
	  href="#help" type="text/html"/>
    <link rel="alternate" title="DNSdoctor" 
	  href="@HTML_PATH@/en/" type="text/html" hreflang="en"/>
    <link rel="alternate" title="DNSdoctor" 
	  href="@HTML_PATH@/zh/" type="text/html" hreflang="zh"/>

    <script src="@HTML_PATH@/js/formvalidation.js"  type="text/javascript"></script>
    <script type="text/javascript">
      zc_form_setlocale("La zone n'a pas été remplie.");
    </script>

    <title>DNSdoctor</title>
  </head>

  <body>
    <!-- Lang -->
    <div class="lang">
      <a href="@HTML_PATH@/en/"><abbr title="English">en</abbr></a> |
      <a href="@HTML_PATH@/fr/" id="current"><abbr title="Fran&ccedil;ais">fr</abbr></a> |
      <a href="@HTML_PATH@/zh/"><abbr title="简体中文">zh</abbr></a></div>

    <!-- Logo -->
    <h1>Diagnostiquez votre domaine</h1>
    <div>
      <img class="ddoc-logo" src="@HTML_PATH@/img/logo_l.png" alt="DNSdcotor logo"/>
    </div>

    <!-- Propaganda -->
    <p><a href="http://www.dnsdoctor.org/">DNSdoctor</a> va effectuer
      plusieurs test sur votre de domaine, de façon a s'assurer qu'il
      est correctement configuré, afin que vous puissiez profiter
      pleinement et sans problemes de votre domaine. Pour de plus amples
      information sur les risques potentiels liés à un domain mal configuré,
      regardez la <a href="http://www.dnsdoctor.org/">page princpale de 
      DNSdoctor</a>.</p>
      
    <!-- Warning about waiting time -->
    <blockquote class="ddoc-warning">
      <p><img src="@HTML_PATH@/img/notepad.png" alt="Note: "
              style="padding: 0.5ex; float: left;"/>
        Le temps nécessaire à une vérification complète du domaine
	peut prendre de 30 secondes jusqu'à <b>5 minutes</b> selon
	la vitesse du réseau pour accéder aux serveurs.
	Si la vérification prend plus d'une minute, cela signifie
	qu'il y a des problèmes pour accéder a vos serveurs
	(erreur de configuration, firewall, ...) et que le programme
	est en attente de <i>timeouts</i>.</p>
    </blockquote>
    
    <!-- A little help -->
    <p>Vous trouverez dans la section <a href="#help">aide</a> une 
      description des différentes options que vous pouvez changer
      pour adapter cet outil, mais le choix par défaut est idéal pour
      quasiment tout utilisateur; il y a également une courte explication
      sur la faison de lire le diagnostique.</p>

    <!-- Form -->
    <form id="ddocform" method="get" action="@HTML_PATH@/cgi-bin/diagnose.cgi"
          class="ddoc-form" onsubmit="return ddoc_form_validate(this)">

      <!-- Basic information -->
      <h2>Formulaire</h2>
      <p>Les <abbr title="Internationalized Domain Names">IDN</abbr> ne
      sont pas pour l'instant supportés, si vous voulez utiliser de tels
      noms, il faudra entrer la forme
      <abbr title="codage commençant par: xn--">punnycode</abbr>.</p>


      <fieldset class="ddoc-zoneinfo">
        <legend>Information sur la zone</legend>
        <table>
	  <tr>
	    <td><img src="@HTML_PATH@/img/zone.png" alt="" title="Zone"/></td>
	    <td colspan="4">
	      <input name="zone" type="text" size="62" value=""/></td>
	  </tr>
          <tr><th></th><th>Serveur de noms</th><th>Addresse(s) IP</th></tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/primary.png" alt="" title="Primary"/></td>
	    <td><input name="ns0"  type="text" size="24" value=""/></td>
	    <td><input id="ips0" name="ips0"
                       type="text" size="35" value=""/></td>
	  </tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/secondary.png" alt="" title="Secondary"/></td>
	    <td><input name="ns1"  type="text" size="24" value=""/></td>
	    <td><input name="ips1" type="text" size="35" value=""/></td>
	  </tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/secondary.png" alt="" title="Secondary"/></td>
	    <td><input name="ns2"  type="text" size="24" value=""/></td>
	    <td><input name="ips2" type="text" size="35" value=""/></td>
	  </tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/secondary.png" alt="" title="Secondary"/></td>
	    <td><input name="ns3"  type="text" size="24" value=""/></td>
	    <td><input name="ips3" type="text" size="35" value=""/></td>
	  </tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/secondary.png" alt="" title="Secondary"/></td>
	    <td><input name="ns4"  type="text" size="24" value=""/></td>
	    <td><input name="ips4" type="text" size="35" value=""/></td>
	  </tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/secondary.png" alt="" title="Secondary"/></td>
	    <td><input name="ns5"  type="text" size="24" value=""/></td>
	    <td><input name="ips5" type="text" size="35" value=""/></td>
	  </tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/secondary.png" alt="" title="Secondary"/></td>
	    <td><input name="ns6"  type="text" size="24" value=""/></td>
	    <td><input name="ips6" type="text" size="35" value=""/></td>
	  </tr>
	  <tr>
	    <td><img src="@HTML_PATH@/img/secondary.png" alt="" title="Secondary"/></td>
	    <td><input name="ns7"  type="text" size="24" value=""/></td>
	    <td><input name="ips7" type="text" size="35" value=""/></td>
	  </tr>
        </table>
      </fieldset>

      <!-- Buttons -->
      <div>
        <input type="submit" value=" Diagnostiquer! "/>
        <script type="text/javascript">
	  document.writeln('<input type="button" value=" Effacer " onclick="ddoc_form_clear(this.form)" />')
        </script>
      </div>

      <!-- Options -->
      <h2>Options</h2>
      <fieldset class="ddoc-options">
      <legend>Sortie</legend>
        <table>
          <tr>
	    <td><input type="checkbox" id="intro" name="intro"
                        checked="checked" value="t" />
	      <label for="intro">Résumé sur la zone</label></td>
	    <td><label for="format">Sortie:</label>
              <select id="format" name="format">
		<option value="html" selected="selected">HTML</option>
		<option value="text"                    >Text</option>
	      </select>
	    </td>
	    <td><label for="lang">Langage:</label>
              <select id="lang" name="lang">
		<option value="en"                    >English</option>
		<option value="fr" selected="selected">Français</option>
		<option value="zh"                    >简体中文</option>
	      </select>
	    </td>
          </tr><tr>
	    <td><input type="checkbox" id="testname" name="testname"
                       value='t'/>
	      <label for="testname">Nom du test</label></td>
	    <td><input type="checkbox" name="explain" id="explain"
                       value='t' checked="checked"/>
	      <label for="explain">Explications</label></td>
	    <td><input type="checkbox" name="details" id="details"
                       value='t' checked="checked"/>
	      <label for="details">Détails</label></td>
          </tr><tr>
	    <td><input type="radio" id="progress1" name="progress"
                       value='counter' checked="checked"/>
	      <label for="progress1">Barre de progression</label></td>
	    <td><input type="radio" id="progress2" name="progress"
                       value='testdesc'/>
	      <label for="progress2">Description</label></td>
	    <td><input type="radio" id="progress3" name="progress"
                       value=''/>
	      <label for="progress3">Rien</label></td>
          </tr>
        </table>
      </fieldset>

      <fieldset class="ddoc-options">
      <legend>Rapport d'errors</legend>
        <table>
	  <tr>
	    <td><input type="radio" id="errorlvl1" name="errorlvl"
                       value="" checked="checked"/>
	      <label for="errorlvl1">Sévérité standard</label></td>
	    <td><input type="radio" id="errorlvl2" name="errorlvl"
                       value="allfatal"/>
	      <label for="errorlvl2">Tout est fatal</label></td>
	    <td><input type="radio" id="errorlvl3" name="errorlvl"
                       value="allwarning"/>
	      <label for="errorlvl3">Tout est avertissement</label></td>
	  </tr>
	  <tr>
	    <td><input type="checkbox" id="dontstop" name="dontstop"
                       value="nostop"/>
	      <label for="dontstop">Continue après fatal</label></td>
	    <td><input type="checkbox" id="fatalonly" name="fatalonly"
                       value="t"/>
	      <label for="fatalonly">Erreurs fatals uniquement</label></td>
	    <td><input type="checkbox" id="reportok" name="reportok"
                       value="t"/>
	      <label for="reportok">Affiche ok</label></td> 
	  </tr>
	  <tr>
	    <td><label for="profile">Profile:</label>
              <select id="profile" name="profile">
		<option value="automatic" selected="selected">automatique</option>
                <optgroup label="automatic profiles">
		  <option value="default"           >Default</option>
		  <option value="reverse"           >Reverse</option>
		</optgroup>
                <optgroup label="available profiles">
		  <option value="afnic"             >AFNIC</option>
		</optgroup>
	      </select></td>
	    <td><label for="report">Trié par:</label>
              <select id="report" name="report">
		<option value="byseverity"
                        selected="selected">sévérité</option>
		<option value="byhost"     >machine</option>
	      </select>
	    </td>
	    <td></td>
	  </tr>
        </table>
      </fieldset>

      <fieldset class="ddoc-options">
      <legend>Tests supplémentaires effectués</legend>
        <table>
	  <tr>
	    <td><input type="checkbox" id="chkmail" name="chkmail"
                       value='t' checked="checked"/>
	      <label for="chkmail">Distribution du courrier</label></td>
	    <td><input type="checkbox" id="chkzone" name="chkzone"
                       value='t' disabled="disabled"/>
	      <label for="chkzone">Transfert de zone</label></td>
	    <td><input type="checkbox" id="chkrir" name="chkrir"
                       value='t' disabled="disabled"/>
	      <label for="chkrir">Base de données <acronym title="Regional Internet Registry">RIR</acronym></label></td>
	  </tr>
        </table>
      </fieldset>

      <fieldset class="ddoc-options">
      <legend>Couche transport</legend>
        <table>
	  <tr>
	    <td><input type="checkbox" id="ipv4" name="transp3"
                       value="ipv4" checked="checked"/>
	      <label for="ipv4"><acronym title="Internet Protocol version 4">IPv4</acronym></label></td>
	    <td><input type="checkbox" id="ipv6" name="transp3"
                       value="ipv6" checked="checked"/>
	      <label for="ipv6"><acronym title="Internet Protocol version 6">IPv6</acronym></label></td>
	  </tr>
	  <tr>
	    <td><input type="radio" id="transp4std" name="transp4"
                       value="std" checked="checked"/>
	      <label for="transp4std"><acronym title="UDP avec repli sur TCP en cas de réponse tronquée">STD</acronym></label></td>
	    <td><input type="radio" id="transp4udp" name="transp4"
                       value="udp"/>
	      <label for="transp4udp"><acronym title="User Datagram Protocol">UDP</acronym></label></td>
	    <td><input type="radio" id="transp4tcp" name="transp4"
                       value="tcp"/>
	      <label for="transp4tcp"><acronym title="Transport Control Protocol">TCP</acronym></label></td>
	  </tr>
        </table>
      </fieldset>
    </form>


    <!-- Help -->
    <h2 id="help">Aide</h2>
    <h3>Formulaires</h3>
    <table rules="rows" class="ddoc-help">
	<tr><th colspan="2">Information sur la zone</th></tr>
	<tr>
	  <td>Zone</td>
	  <td>Le domaine qui doit être testé (le nom de
	    domaine qui doit être enregistré).</td>
	</tr>
	<tr>
	  <td>Primaire</td>
	  <td>Le serveur de noms qui est considéré comme primaire (celui qui
	    figure dans l'enregistrement du SOA, si celui-ci est public).</td>
	</tr>
	<tr>
	  <td>Secondary</td>
	  <td>Le serveur de noms secondaire (tous les enregistrement NS
	    associés avec le domaine), à l'exception de celui listé ci-dessus.
	  </td>
	</tr>
	<tr>
	  <td>IP</td>
	  <td>Liste des adresses IP associées avec le serveur de noms.
	    <UL>
	      <LI>elles sont uniquement requises si elles ne peuvent être
		déduites (elles sont dans la zone qui est actuellement
		en cours d'enregistrement),</LI>
	      <LI>s'il y a plusieurs adresses, elle doivent être séparées
		par un espace ou une virgule,</LI>
	      <LI>le formulaire accepte aussi bien les adresses IPv4
		qu'IPv6 (à l'exception des compatibles et mappées).</LI>
	    </UL>
	  </td>
	</tr>

	<tr><th colspan="2">Option: Sortie</th></tr>
	<tr>
	  <td>résumé sur la zone</td>
	  <td>Inclus un résumé sur la zone et ces serveurs de noms dans le 
	    rapport généré</td>
	</tr>
	<tr>
	  <td>nom du test</td>
	  <td>Inclus le nom du test qui a été réalisé</td>
	</tr>
	<tr>
	  <td>explications</td>
	  <td>Inclus une explication sur la raison du test et pourquoi
	    il doit être corrigé (quand le test a échoué).</td>
	</tr>
	<tr>
	  <td>détails</td>
	  <td>Inclus des détails sur les éléments coupables 
	    (quand le test a échoué).</td>
	</tr>
	<tr>
	  <td>barre de progression</td>
	  <td>Affiche des informations à propos du déroulement des 
	    tests en utilisant une barre de progression (<I>nécessite
	      javascript et Mozilla ou IE5+ pour un rendu correct</I>).</td>
	</tr>
	<tr>
	  <td>description</td>
	  <td>Donne une courte description sur le test effectué.</td>
	</tr>
	<tr>
	  <td>rien</td>
	  <td>N'affiche aucune information sur la progression des tests.</td>
	</tr>
	<tr>
	  <td>rapport</td>
	  <td>Sélectionne le type de rapport qui doit être généré.</td>
	</tr> 
	<tr>
	  <td>format</td>
	  <td>Sélectionne le format dans lequel le rapport doit être généré
	    (HTML ou texte simple).</td>
	</tr> 
	<tr>
	  <td>langue</td>
	  <td>Sélectionne la langue dans laquelle le rapport doit être
	    généré.</td>
	</tr> 

	<tr><th colspan="2">Option: rapport d'erreurs</th></tr>
	<tr>
	  <td>sévérité par défaut</td>
	  <td>Les erreurs sont rapportées avec le degré de sévérité associé
	    au test.</td>
	</tr>
	<tr>
	  <td>tout fatal</td>
	  <td>Toute erreur est considérée comme fatale.</td>
	</tr>
	<tr>
	  <td>tout avertissement</td>
	  <td>Toute erreur est considérée comme un avertissement.</td>
	</tr>
	<tr>
	  <td>continue après fatal</td>
	  <td>Continue même après avoir rencontré une erreur fatale
	    (<I>cela peut conduire à des résultats inattendus</I>).</td>
	</tr>
	<tr>
	  <td>affiche ok</td>
	  <td>Affiche les tests qui sont passés sans erreur.</td>
	</tr>

	<tr><th colspan="2">Option: tests supplémentaires effectués</th></tr>
	<tr>
	  <td>distribution du courrier</td>
	  <td>Effectue des vérifications supplémentaires
	    sur la distribution du courrier pour des comptes utilisateurs
	    typiques (hostmaster, postmaster, ...) associés avec les
	    noms de domaine.</td>
	</tr>
	<tr>
	  <td>transfert de zone</td>
	  <td>Effectue un <I>transfert de zone</I> sur lequel des tests
	    supplémentaires sont effectués.</td>
	</tr>
	<tr>
	  <td>bases de données RIR</td>
	  <td>Vérifie que les adresses IP sont bien enregistrées
	    dans la base des RIR</td>
	</tr>

	<tr><th colspan="2">Option: Couche transport</th></tr>
	<tr>
	  <td>IPv4, IPv6</td>
	  <td>Sélectionne la couche de routage (si aucune n'est sélectionnée
	    le défaut est de prendre IPv4 et IPv6).</td>
	</tr>
	<tr>
	  <td>STD, UDP, TCP</td>
	  <td>Sélectionne la couche de transport à utiliser pour interroger
	    les serveurs de noms.</td>
	</tr>
    </table>

    <h3>Résultats</h3>
    <ul>
      <li>le mot <i>générique</i> signifie que l'erreur est soit
	indépendante soit présente sur tous les serveurs de noms,</li>
      <li>lorsqu'une erreur est entre [crochets], cela signifie
	que le test a échoué pour une raison externe (cette raison
	est affichée à côté).</li>
    </ul>


    <!-- What / Who / When -->
    <div>
      <hr/>
      <span style="float: right;">
        <a href="http://jigsaw.w3.org/css-validator/check/referer">
	  <img style="border:0;width:88px;height:31px;"
	       src="http://jigsaw.w3.org/css-validator/images/vcss" 
  	       alt="Valid CSS!"/></a>
        <a href="http://validator.w3.org/check/referer">
	  <img style="border:0;width:88px;height:31px;"
	       src="http://www.w3.org/Icons/valid-xhtml11"
	       alt="Valid XHTML 1.1!"/></a>
      </span>
Release: $Name: DDOC-1_0_1 $ <br/>
<!-- Created: Fri Sep 27 16:34:31 CEST 2002 -->
<!-- hhmts start -->
Last modified: Fri Feb 10 13:40:02 CET 2006
<!-- hhmts end -->
    </div>
  </body>

<!-- Local Variables: -->
<!-- mode: html       -->
<!-- End:             -->

</html>
