<?xml version='1.0' encoding='UTF-8'?>
<!DOCTYPE config PUBLIC "-//DNSdoctor//DTD Config V1.0//EN" "msgcat.dtd">
<msgcat lang="fr">
<!-- $Id: generic.fr,v 1.2 2004/10/06 08:45:21 sdalu Exp $ -->

<!--
# 
# CONTACT     : http://www.dnsdoctor.org/
# AUTHOR      : Stephane D'Alu <sdalu@sdalu.com>
#
# CREATED     : 2002/08/02 13:58:17
# REVISION    : $Revision: 1.2 $ 
# DATE        : $Date: 2004/10/06 08:45:21 $
#
# CONTRIBUTORS: (see also CREDITS file)
#
#
# LICENSE     : GPL v2
# COPYRIGHT   : AFNIC (c) 2003
#
# This file is part of DNSdoctor.
#
# DNSdoctor is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# DNSdoctor is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with DNSdoctor; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
-->

  <!-- Shortcuts -->
  <shortcut>
    <explanation name="label">
      <src type="ref" from="rfc" fid="rfc1034#p11">
        <title>IETF RFC1034 (p.11)</title>
        <para>Labels are only composed by letters ([A-Za-z]), digits ([0-9]) or dashes ('-') (not starting or ending with), and should be less than 63 characters; domain name (labels separated by '.') should be less than 255 characters. See also [ref]: IETF RFC1912 (2.1 Inconsistent, Missing, or Bad Data).</para>
      </src>
    </explanation>

    <explanation name="rfc2182">
      <src type="adv" from="dnsdoctor">
        <title>DNSdoctor</title>
        <para>To avoid loosing all connectivity with the autoritative DNS
          in case of network outage it is advised to host the DNS on
          different networks.</para>
      </src>
      <src type="ref" from="rfc" fid="rfc2182">
        <title>IETF RFC2182 (Abstract)</title>
        <para>The Domain Name System requires that multiple servers exist for every delegated domain (zone).  This document discusses the selection of secondary servers for DNS zones.  Both the physical and topological location of each server are material considerations when selecting secondary servers.  The number of servers appropriate for a zone is also discussed, and some general secondary server maintenance issues considered.</para>
      </src>
    </explanation>
  </shortcut>


  <!-- Checks -->
  <check name="dn_sntx">
    <name>nom de domaine contenant des caractères illégaux</name>
    <success>Le nom de domaine ne contient aucun caractère illégal</success>
    <failure>Le nom de domaine contient des caractères illégaux</failure>
    <explanation sameas="shortcut:label"/>
    <details/>
  </check>


  <check name="dn_orp_hyph">
    <name>tiret ('-') au début ou à la fin du nom de domaine</name>
    <success>Aucune mauvaise utilisation du tiret ('-') dans le nom de domaine</success>
    <failure>Le nom de domaine commence ou finit par un tiret ('-')</failure>
    <explanation sameas="shortcut:label"/>
    <details/>
  </check>


  <check name="dn_dbl_hyph">
    <name>double tiret ('--') dans le nom de domaine</name>
    <success>Pas d'utilisation du double tiret ('--')</success>
    <failure>Le nom de domaine contient un double tiret ('--')</failure>
    <explanation>
      <src type="ref">
        <title>IETF IDN project (internationalized domain names)</title>
        <para>The double dash ('--') will have a special meaning for
          the domain name encoding, so it is strongly advised not to
          used it. See <uri link="http://www.iana.org/cctld/specifications-policies-cctlds-01apr02.htm">http://www.iana.org/cctld/specifications-policies-cctlds-01apr02.htm</uri> (4. Tagged Domain Names.)</para>
      </src>
    </explanation>
    <details/>
  </check>

  <check name="one_ns">
    <name>présence de serveurs de nom gérant le domaine</name>
    <success>Au moins un serveur de nom présent</success>
    <failure>Au moins un serveur de nom est requis</failure>
    <explanation sameas="shortcut:rfc2182"/>
    <details/>
  </check>


  <check name="several_ns">
    <name>présence d'au moins deux serveurs de noms pour le domaine</name>
    <success>Au moins deux serveurs de noms présents</success>
    <failure>Au moins deux serveurs de noms sont nécessaires</failure>
    <explanation sameas="shortcut:rfc2182"/>
    <details/>
  </check>


  <check name="ip_distinct">
    <name>adresses IP identiques parmi les serveurs</name>
    <success>Toutes les adresses IP sont distinctes</success>
    <failure>Toutes les adresses IP doivent être distinctes</failure>
    <explanation sameas="shortcut:rfc2182"/>
    <details><para>Les serveurs de noms <var name="ns"/> utilisent la
      même adresse IP (<var name="ip"/>).</para></details>
  </check>


  <check name="ip_same_net">
    <name>serveurs de noms sur le même sous-réseau</name>
    <success>Aucun serveur de nom n'est sous le même sous-réseau</success>
    <failure>Des serveurs sont sur le même sous-réseau</failure>
    <explanation sameas="shortcut:rfc2182"/>
    <details><para>Les sous-réseaux suivants sont utilisés par plusieurs
      hôtes: <var name="subnets"/>. Essayez de déplacer certains hôtes
      sur un autre sous-réseau.</para></details>
  </check>


  <check name="ip_all_same_net">
    <name>serveurs de noms tous sur le même sous-réseau</name>
    <success>Les serveurs de noms ne sont probablement pas tous sur le même sous-réseau</success>
    <failure>Les serveurs de noms semblent être tous sur le même sous-réseau</failure>
    <explanation sameas="shortcut:rfc2182"/>
    <details><para>Tous les serveurs de noms semblent être dans le sous-réseau
      <var name="subnet"/>. Essayez d'en déplacer quelques uns sur un
      autre sous-réseau.</para></details>
  </check>


  <check name="all_same_asn">
    <name>serveurs de noms appartenant tous au même AS</name>
    <success>Tous les serveurs de noms ne font partie du même AS</success>
    <failure>Les serveurs de nom font tous partie du même AS</failure>
    <explanation>
      <src type="adv" from="dnsdoctor">
        <title>DNSdoctor</title>
        <para>Afin d'éviter de perdre la connectivité avec les serveurs
          DNS autoritaires en cas de problèmes de routage dans
          le Système Autonome, il est conseillé d'héberger les serveurs
          sur différents AS.</para>
      </src>
    </explanation>
    <details><para>Tous les serveurs de noms font partie du même 
      Système Autonome (AS numéro <var name="asn"/>), essayez d'en
      héberger certains sur un autre.</para></details>
  </check>


  <check name="all_same_domain">
    <name>serveurs de noms appartenant tous au même domaine</name>
    <success>Tous les serveurs de noms ne font partie du même domaine</success>
    <failure>Les serveurs de nom font tous partie du même domaine</failure>
    <explanation>
      <src type="adv" from="dnsdoctor">
        <title>DNSdoctor</title>
        <para>Afin d'éviter d'avoir votre domaine non resolvable à cause
          du fait que le domain qui contient tous vos serveurs de nom
          ne peut plus être résolu, il est conseillé de placer les serveurs
          sur différents domaines.</para>
      </src>
    </explanation>
    <details><para>Tous les serveurs de noms font partie du même
      domaine (<var name="subdomain"/>), essayez d'en
      placer certains sur un autre.</para></details>
  </check>


  <check name="delegation_udp512">
    <name>delegation response fit in a 512 byte UDP packet</name>
    <success>Delagation response fit in a 512 byte UDP packet</success>
    <failure>Delegation response won't fit in a 512 byte UDP packet</failure>
    <explanation/>
    <details><para>Pour une requête de <const name="delegation_query_size"/> 
      octets, il n'est pas possible d'envoyer la liste complete des 
      serveurs de noms (<var name="excess"/> octets en 
      trop).</para></details>
  </check>


  <check name="delegation_udp512_additional">
    <name>delegation response with additional fit in a 512 byte UDP packet</name>
    <success>Delagation response with additional fit in a 512 byte UDP packet</success>
    <failure>Delegation response with additional won't fit in a 512 byte UDP packet</failure>
    <explanation/>
    <details><para>Pour une requête de <const name="delegation_query_size"/>
      octets, il n'est pas possible d'envoyer la liste complete des serveurs
      de noms avec leurs glues correspondantes (<var name="excess"/> 
      octets en trop).</para></details>
  </check>

  <!-- Local Variables: -->
  <!-- mode: xml        -->
  <!-- End:             -->
</msgcat>
