Summary: Perform consistency checks on DNS zones
Name: dnsdoctor
Version: 1.0.1
Release: 1
License: GPL
Group: Applications/Internet
URL: http://www.dnsdoctor.fr/

Packager: Someone <http://www.dnsdoctor.org/>
Vendor: The DNSdoctor Team

Source: http://www.dnsdoctor.org/download/src/%{name}-%{version}.tgz
BuildRoot: %{_tmppath}/root-%{name}-%{version}
BuildArch: noarch

BuildRequires: ruby >= 1.8.1, ruby-libs
Requires: ruby >= 1.8.1, ruby-libs

%description
DNSdoctor is intended to help solve DNS misconfigurations or
inconsistencies that are usually revealed by an increase in
the latency of the application. The DNS is a critical resource
for every network application, so it is quite important to
ensure that a zone or domain name is correctly configured in
the DNS.

%package cgi
Summary: Web service interface for DNSdoctor
Group: Applications/Internet
Requires: %{name} = %{version}

%description cgi
Provide a web service interface for DNSdoctor.
(DNSdoctor is intended to help solve DNS misconfigurations)

%prep
%setup -n %{name}

%build
%{__rm} -rf %{buildroot}

%install
ruby ./installer.rb common cli cgi	\
	-DPREFIX="%{_prefix}"		\
	-DETCDIR="%{_sysconfdir}"	\
	-DLIBEXEC="%{_libexecdir}"	\
	-DMANDIR="%{_mandir}"		\
	-DETCDIST=""			\
	-DCHROOT="%{buildroot}"

case `uname` in
	OSF1)
ruby -p -i \
	-e "\$_.gsub"\!"(/(<const\s+name\s*=\s*\"ping4\"\s+value\s*=\s*\")[^\"]*(\"\s*\/>)/, '\1/sbin/ping -n -q -t 5 -c 5 %s > /dev/null\2')" \
	-e "\$_.gsub"\!"(/(<const\s+name\s*=\s*\"ping6\"\s+value\s*=\s*\")[^\"]*(\"\s*\/>)/, '\1/sbin/ping -n -q -t 5 -c 5 %s > /dev/null\2')" \
	%{buildroot}%{_sysconfdir}/dnsdoctor/dnsdoctor.conf
	;;

	*)
ruby -p -i \
	-e "\$_.gsub"\!"(/(<const\s+name\s*=\s*\"ping4\"\s+value\s*=\s*\")[^\"]*(\"\s*\/>)/, '\1/bin/ping -n -q -w 5 -c 5 %s > /dev/null\2')" \
	-e "\$_.gsub"\!"(/(<const\s+name\s*=\s*\"ping6\"\s+value\s*=\s*\")[^\"]*(\"\s*\/>)/, '\1/usr/sbin/ping6 -n -q -w 5 -c 5 %s > /dev/null\2')" \
	%{buildroot}%{_sysconfdir}/dnsdoctor/dnsdoctor.conf
	;;
esac

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-, root, root, 0755)
%doc ChangeLog COPYING CREDITS GPL HISTORY README
%doc doc/html
%dir %{_sysconfdir}/dnsdoctor
%config %{_sysconfdir}/dnsdoctor/rootservers
%config %{_sysconfdir}/dnsdoctor/*.profile
%verify(not size,not md5) %config(noreplace) %{_sysconfdir}/dnsdoctor/dnsdoctor.conf
%{_bindir}/*
%dir %{_libexecdir}/dnsdoctor
%{_libexecdir}/dnsdoctor/dnsdoctor
%{_libexecdir}/dnsdoctor/lib
%{_libexecdir}/dnsdoctor/locale
%{_libexecdir}/dnsdoctor/test
%{_mandir}/man1/*

%files cgi
%defattr(-, root, root, 0755)
%{_libexecdir}/dnsdoctor/www
%{_libexecdir}/dnsdoctor/cgi-bin

%changelog
* Tue Sep 14 2004 Stephane D'Alu <sdalu@sdalu.com> - 1.0.0 (DNSdoctor)
- Updated for DNSdoctor

* Mon Nov 13 2003 Stephane D'Alu <sdalu@nic.fr> - 2.0.0b10
- Updated for new zone configuration profile.

* Fri Oct 24 2003 Jean-Philippe Pick <http://www.zonecheck.fr/> - 2.0.0b9
- Reworked packaging to meet new installation process.

* Tue Sep 02 2003 Dag Wieers <dag@wieers.com> - 2.0.0-0.b7
- Initial package. (using DAR)

