/*
 * nespal.c
 *
 * contains RGB values for the NES palette.
 */

/* $Id: nespal.c,v 1.6 1999/01/30 02:32:18 nyef Exp $ */

#if 1 /* palette from Magnus Oman */
int nes_palbase_red[64] = {
    0x7f,0x00,0x00,0x47,0x97,0xab,0xab,0x8b,0x53,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0xbf,0x00,0x00,0x6b,
    0xdb,0xe7,0xf8,0xe7,0xaf,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0xf8,0x3f,0x6b,0x98,0xf8,0xf8,0xf8,0xff,
    0xf8,0xb8,0x5b,0x58,0x00,0x78,0x00,0x00,0xff,0xa7,
    0xb8,0xd8,0xf8,0xfb,0xf0,0xff,0xfb,0xd8,0xb8,0xb8,
    0x00,0xf8,0x00,0x00
};

int nes_palbase_green[64] = {
    0x7f,0x00,0x00,0x2b,0x00,0x00,0x13,0x17,0x30,0x78,
    0x6b,0x5b,0x43,0x00,0x00,0x00,0xbf,0x78,0x58,0x47,
    0x00,0x00,0x38,0x5f,0x7f,0xb8,0xab,0xab,0x8b,0x00,
    0x00,0x00,0xf8,0xbf,0x88,0x78,0x78,0x58,0x78,0xa3,
    0xb8,0xf8,0xdb,0xf8,0xeb,0x78,0x00,0x00,0xff,0xe7,
    0xb8,0xb8,0xb8,0xa7,0xd0,0xe3,0xdb,0xf8,0xf8,0xf8,
    0xff,0xd8,0x00,0x00
};

int nes_palbase_blue[64] = {
    0x7f,0xff,0xbf,0xbf,0x87,0x23,0x00,0x00,0x00,0x00,
    0x00,0x00,0x58,0x00,0x00,0x00,0xbf,0xF8,0xf8,0xff,
    0xcd,0x5b,0x00,0x13,0x00,0x00,0x00,0x47,0x8b,0x00,
    0x00,0x00,0xf8,0xff,0xff,0xf8,0xf8,0x98,0x58,0x47,
    0x00,0x18,0x57,0x98,0xdb,0x78,0x00,0x00,0xff,0xff,
    0xf8,0xf8,0xf8,0xc3,0xb0,0xab,0x7b,0x78,0xb8,0xd8,
    0xff,0xf8,0x00,0x00
};
#endif

#if 0 /* original palette */
int nes_palbase_red[64] = {
    139,   0,   0,  90, 106, 123, 139, 123, 106,  90,   0,   0,   0,    0,0,0,
    205,  67,  67, 133, 152, 171, 205, 171, 152, 133,  67,  67,  67,    0,0,0,
    238,  90,  90, 154, 182, 210, 238, 210, 182, 154,  90,  90,  90,    0,0,0,
    255, 135, 135, 165, 195, 225, 255, 225, 195, 165, 135, 135, 135,    0,0,0,
};

int nes_palbase_green[64] = {
    139,  90,   0,   0,   0,   0,   0,  90, 106, 123, 139, 123, 106,    0,0,0,
    205, 133,  67,  67,  67,  67,  67, 133, 152, 171, 205, 171, 152,    0,0,0,
    238, 154,  90,  90,  90,  90,  90, 154, 182, 210, 238, 210, 182,    0,0,0,
    255, 165, 135, 135, 135, 135, 135, 165, 195, 225, 255, 225, 195,    0,0,0,
};

int nes_palbase_blue[64] = {
    139, 123, 139, 123, 106,  90,   0,   0,   0,   0,   0,  90, 106,    0,0,0,
    205, 171, 205, 171, 152, 133,  67,  67,  67,  67,  67, 133, 152,    0,0,0,
    238, 210, 238, 210, 182, 154,  90,  90,  90,  90,  90, 154, 182,    0,0,0,
    255, 225, 255, 225, 195, 165, 135, 135, 135, 135, 135, 165, 195,    0,0,0,
};
#endif

#if 0
int nes_palbase_red[64] = {
    0x75, 0x27, 0x00, 0x47, 0x8f, 0xab, 0xa7, 0x7f,
    0x43, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,

    0xbc, 0x00, 0x23, 0x83, 0xbf, 0xe7, 0xdb, 0xcb,
    0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0xff, 0x3f, 0x5f, 0xa7, 0xf7, 0xff, 0xff, 0xff,
    0xf3, 0x83, 0x4f, 0x58, 0x00, 0x00, 0x00, 0x00,

    0xff, 0xab, 0xc7, 0xd7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe3, 0xab, 0xb3, 0x9f, 0x00, 0x00, 0x00,
};

int nes_palbase_green[64] = {
    0x75, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b,
    0x2f, 0x47, 0x51, 0x3f, 0x3f, 0x00, 0x00, 0x00,

    0xbc, 0x73, 0x3b, 0x00, 0x00, 0x00, 0x2b, 0x4f,
    0x73, 0x97, 0xab, 0x93, 0x83, 0x00, 0x00, 0x00,

    0xff, 0xbf, 0x97, 0x8b, 0x7b, 0x77, 0x77, 0x9b,
    0xbf, 0xd3, 0xdf, 0xf8, 0xeb, 0x00, 0x00, 0x00,

    0xff, 0xe7, 0xd7, 0xcb, 0xc7, 0xc7, 0xbf, 0xdb,
    0xe7, 0xff, 0xf3, 0xff, 0xff, 0x00, 0x00, 0x00,
};

int nes_palbase_blue[64] = {
    0x75, 0x8f, 0xab, 0x9f, 0x77, 0x13, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x17, 0x5f, 0x00, 0x00, 0x00,

    0xbc, 0xef, 0xef, 0xf3, 0xbf, 0x5b, 0x00, 0x0f,
    0x00, 0x00, 0x00, 0x3b, 0x8b, 0x00, 0x00, 0x00,

    0xff, 0xff, 0xff, 0xfd, 0xff, 0xb7, 0x63, 0x3b,
    0x3f, 0x13, 0x4b, 0x98, 0xdb, 0x00, 0x00, 0x00,

    0xff, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xb3, 0xab,
    0xa3, 0xa3, 0xbf, 0xcf, 0xf3, 0x00, 0x00, 0x00,
};
#endif

#if 0
int nes_palbase_red[64] = {
    117, 39,  0, 71,143,171,167,127,
     67,  0,  0,  0, 27,  0,  0,  0,

    188,  0, 35,131,191,231,219,203,
    139,  0,  0,  0,  0,  0,  0,  0,

    255, 63, 95,167,247,255,255,255,
    243,131, 79, 88,  0,  0,  0,  0,

    255,171,199,215,255,255,255,255,
    255,227,171,179,159,  0,  0,  0,
};

int nes_palbase_green[64] = {
    117, 27,  0,  0,  0,  0,  0, 11,
     47, 71, 81, 63, 63,  0,  0,  0,

    188,115, 59,  0,  0,  0, 43, 79,
    115,151,171,147,131,  0,  0,  0,

    255,191,151,139,123,119,119,155,
    191,211,223,248,235,  0,  0,  0,

    255,231,215,203,199,199,191,219,
    231,255,243,255,255,  0,  0,  0,
};

int nes_palbase_blue[64] = {
    117,143,171,159,119, 19,  0,  0,
      0,  0,  0, 23, 95,  0,  0,  0,

    188,239,239,243,191, 91,  0, 15,
      0,  0,  0, 59,139,  0,  0,  0,

    255,255,255,253,255,183, 99, 59,
     63, 19, 75,152,219,  0,  0,  0,

    255,255,255,255,255,219,179,171,
    163,163,191,207,243,  0,  0,  0,
};
#endif

#if 0
int nes_palbase_red[64] = {
    0x68, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x55, /* 00-07 */
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 08-0f */

    0x98, 0x00, 0x40, 0x00, 0x00, 0xc0, 0xc0, 0xc0, /* 10-17 */
    0x80, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00, /* 18-1f */

    0xd0, 0x40, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, /* 20-27 */
    0xc0, 0x80, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, /* 28-2f */

    0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, /* 30-37 */
    0xff, 0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, /* 38-3f */
};
int nes_palbase_green[64] = {
    0x68, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* 00-07 */
    0x40, 0x00, 0x50, 0x00, 0x40, 0x00, 0x00, 0x00, /* 08-0f */

    0x98, 0x80, 0x40, 0x00, 0x00, 0x00, 0x20, 0x40, /* 10-17 */
    0x80, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x00, /* 18-1f */

    0xd0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x50, 0x80, /* 20-27 */
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, /* 28-2f */

    0xff, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xc0, /* 30-37 */
    0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, /* 38-3f */
};
int nes_palbase_blue[64] = {
    0x68, 0x80, 0x80, 0x00, 0x00, 0x40, 0x00, 0x00, /* 00-07 */
    0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, /* 08-0f */

    0x98, 0xc0, 0xc0, 0x00, 0x00, 0x80, 0x20, 0x00, /* 10-17 */
    0x00, 0x00, 0x00, 0x33, 0x80, 0x00, 0x00, 0x00, /* 18-1f */

    0xd0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x50, 0x40, /* 20-27 */
    0x00, 0x00, 0x00, 0x55, 0xc0, 0x00, 0x00, 0x00, /* 28-2f */

    0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x80, 0x80, /* 30-37 */
    0x40, 0x00, 0x40, 0x00, 0xff, 0x00, 0x00, 0x00, /* 38-3f */
};
#endif

/*
 * $Log: nespal.c,v $
 * Revision 1.6  1999/01/30 02:32:18  nyef
 * added palette from Magnus Oman.
 *
 * Revision 1.5  1998/08/22 16:12:37  nyef
 * more palette tweaks.
 *
 * Revision 1.4  1998/08/18 23:43:21  nyef
 * corrected a few phase errors in the new palette.
 *
 * Revision 1.3  1998/08/16 01:40:15  nyef
 * added in new palette. it may still need tweaking.
 *
 * Revision 1.2  1998/08/01 00:56:53  nyef
 * moved old palette values in from video_x.c
 *
 * Revision 1.1  1998/07/11 22:18:20  nyef
 * Initial revision
 *
 */
