/*
**  Copyright (c) 2004 Sendmail, Inc. and its suppliers.
**	All rights reserved.
**
**  $Id: util.h,v 1.17 2005/04/29 00:06:41 msk Exp $
*/

#ifndef _UTIL_H_
#define _UTIL_H_

/* system includes */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

/* libsm includes */
#include <sm/gen.h>

/* dk-filter includes */
#include "dk-filter.h"

#ifndef lint
static char util_h_id[] = "@(#)$Id: util.h,v 1.17 2005/04/29 00:06:41 msk Exp $";
#endif /* !lint */

/* PROTOTYPES */
extern bool dkf_checkhost(Peer list, char *host);
extern bool dkf_checkip(Peer list, struct sockaddr *ip);
#if POPAUTH
extern bool dkf_checkpopauth(DB *db, struct sockaddr *ip);
#endif /* POPAUTH */
extern void dkf_ffrlist(FILE *where);
extern size_t dkf_inet_ntoa(struct in_addr a, char *buf, size_t buflen);
extern bool dkf_load_list(FILE *in, struct Peer **list);
extern void dkf_lowercase(char *str);
extern void dkf_setmaxfd(void);
extern void dkf_splithdrs(char *buf, size_t buflen);
extern void dkf_stripbrackets(char *addr);

#endif /* _UTIL_H_ */
