#!/usr/bin/perl
# $Id: custom.depot2depot.pref.pl,v 1.3 1994/11/07 13:27:24 ww0r Exp $
#
# (c) 1994 Carnegie Mellon University
# 
# converter of custom.depot[.proto] to depot.pref[.proto]
#
# argv[0] should be the path to the custom.depot or custom.depot.proto
# 
# LIMITATIONS: - This program will not covert label.command as the command
#                execution method has changed significantly since depotv4
#              - This program is probably also too v4 -> v5 specific, but
#                hey, that's what counts now.
# RETURN CODES:
#                0 - all ok
#              126 - File already exists
#              127 - label.command detected
#            other - fatal error occured
#

$version = ' $Revision: 1.3 $ ';
$proto = 0;
$depot_version = "depotv5";

if (@ARGV != 1) {
  print "usage: conv custom.depot[.proto]\n";
  exit(-1);
}

$cd = $ARGV[0];

die "No such file or directory: $cd\n"
  if (! -f "$cd" );

@ele = reverse split(/\//, $cd);

$file = shift(@ele);
$dir = join('/', reverse(@ele));

die "Directory not writeable: $dir\n"
  if (($dir)  && (! -w "$dir" ));


if ($file =~ /^custom.depot$/) {
  $output = "depot.pref";
} elsif ($file =~ /^custom.depot.proto$/) {
  $output = "depot.pref.proto";
  $proto = 1;
} else {
  die "ERROR: custom.depot or custom.depot.proto must be specified in the path.\n";
}
$output = "$dir/$output"
  if ($dir);

print "Processing $cd...";
open(IFD, "$cd") ||
  die "Unable to open file for reading: $cd: $!\n";

if ( -f $output ) {
  print STDERR "WARNING: $output already exists. Exiting...\n";
  exit(126);
}

open(OFD, "> $output") || 
  die "Unable to open file for writing: $output: $!\n";

print OFD "#\n# this file automatically generated from $cd.\n";
print OFD "# by the automatic custom.depot to depot.pref converter $version\n#\n";
print OFD "%define $depot_version\n"
  if ($proto);

$count = 0;
while (<IFD>) {
  $count++;
  if ((/^\s*$/)  	# pass on blanks
      || (/\s*\#/) 	# pass on comments
      || (/\s*%/)) { 	# pass on mpp directives (really should omit depotvN...)
    print OFD $_;
    next;
  }

  ($operand, @values) = split(/:/);
  $val = join(':', @values);
  ($name, $option) = split(/\./, $operand);

  if ($option) {		# do the real work in these procedures...
    &process_multiple($name, $option, $val);
  } else {			# (a completely arbitrary splitting)
    &process_single($name, $val);
  }
}

close(IFD);
close(OFD);
print "done\n";

exit($rc);

sub
process_single {
  local($name, $val) = @_;

  $name = &strip_white($name);
  
  if ("$name" eq "copytarget") {
    print OFD "target.installmethod copy "; 
  } elsif ("$name" eq "linktarget") {
    print OFD "target.installmethod link ";
  } elsif ("$name" eq "nooptarget") {
    print OFD "target.installmethod noop "; # 
  } elsif ("$name" eq "deletetarget") {
    print OFD "target.installmethod delete "; # 
  } elsif (("$name" eq "ignore") 
	   || ("$name" eq "usemodtimes") 
	   || ("$name" eq "versiondelimiter") 
	   || ("$name" eq "specialfile")) {
    print OFD "$name ";
  } else {
    print STDERR "Invalid option: $name on line $count of $cd.\n";
    exit(2);
  }
  print OFD "$val";		# assume \n at the end of the line
}

sub
process_multiple {
  local($name, $opt, $val) = @_;
  if (($name eq "label") && ($opt eq "command")) {
    print STDERR "WARNING: Command structures have changed significantly between\n";
    print STDERR "         depot v4 and depot v5. As a result, the label.command\n";
    print STDERR "         on line $count of $cd is NOT\n";
    print STDERR "         being automatically converted\n";
    print OFD "# UNCONVERTED DEPOT V4 ENTRY\n";
    print OFD "# label.command $val";
    $rc = 127;
    return;
  }
  if ("$opt" eq "mapcommand") {
    chop($val);
    print OFD "collection.installmethod $val $name\n";
    return;
  }
  
  print OFD "$opt $name $val";
}

sub
strip_white {
  local($entry) = @_;
  $entry =~ s/^\s*|\s*$//g;
  return $entry;
}

# $Source: /afs/andrew.cmu.edu/system/src/local/depot2/021/tools/conv_tools/RCS/custom.depot2depot.pref.pl,v $
