/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_SortByOverrides.c,v 1.5 1994/09/07 19:50:35 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "Preference.h"


/*
 * $$$NOTE$$$
 *      I wind up having to include Collection.h and the whole schpiele here
 * because I need to have the collectionlist handy to check preferences
 * Better to improve separation by splitting up collectionlist into
 * collectionnamelist and collectionlist - so that TargetDB etc. does not
 * refer to even an include file in Collection module.
 */


static void TargetDB_TreeSortByOverrides();



static void 
TargetDB_TreeSortByOverrides(targetdbp,
			     preferencedb,
			     collectionlistp)
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
{
  register int i;
  register TARGETDB **childp;

  Boolean PreSortedNode;

  if (targetdbp != NULL) {
    TARGETDB_SourceList(targetdbp) =
      SourceList_SortByOverrides(TARGETDB_SourceList(targetdbp),
				 preferencedb,
				 collectionlistp,
				 &PreSortedNode);

#if 0
    /* 
     * if the node was already in sorted order,
     * we assume that so are the children,
     * as would be the case for any target database
     * built using the depot routines
     */
    /* This statement is false.  If you  have a collection 
     * that maps a file via the depot.conf and that files does not exist, then when
     * you add a collection that conflicts with the file, the sourcelist is not necessarily
     * in the right order and so you get a conflict unless you force this sort. -wcw 9/7/94
     */
    if (!PreSortedNode)

#endif
      for (i = 0, childp = TARGETDB_Children(targetdbp);
	   (PROGRAM_ErrorNo == E_NULL)
	   && (i < TARGETDB_ChildCount(targetdbp));
	   i++, childp++) {
	TargetDB_TreeSortByOverrides(*childp,
				     preferencedb,
				     collectionlistp);
      }
    }
  return;
}



void 
TargetDB_SortByOverrides(targetdbp,
			 preferencedb,
			 collectionlistp)
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
{
  TargetDB_TreeSortByOverrides(targetdbp, preferencedb, collectionlistp);

  return;
}

/* $Source: /afs/andrew/system/src/local/depot2/012/src/lib/TargetDB/RCS/TargetDB_SortByOverrides.c,v $ */
