/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: SourceList_Find.c,v 1.3 1994/08/12 22:17:37 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"


int SourceList_FindIndexToCollectionId(sourcelistp,
				       collectionid,
				       flags)
     TARGETSOURCELIST *sourcelistp;
     int collectionid;
     unsigned int flags;
{
  register unsigned int i;

  Boolean FoundCollection;
  int index;

  if (sourcelistp == NULL)
    {
      FatalError(E_BADTARGETSOURCELIST,
		 "Attempt to find collection in NULL targetsourcelist.\n");
    }
  else if (TARGETSOURCELIST_NSources(sourcelistp) == 0)
    index = -1;
  else
    {
      i = 0; FoundCollection = FALSE; index = -1;
      while ((PROGRAM_ErrorNo == E_NULL)
	     && (i < TARGETSOURCELIST_NSources(sourcelistp))
	     && !FoundCollection)
	{
	  if (TARGETSOURCE_CollectionId(TARGETSOURCELIST_Source(sourcelistp, i))
	      == collectionid)
	    { FoundCollection = TRUE; index = i; }
	  i++;
	}
    }

  if ((index < 0) && !(flags & TDB_LAX))
    {
      FatalError(E_BADCOLLECTIONID,
		 "Could not find collection id %d in targetsourcelist.\n",
		 collectionid);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? index : -1;
}


int SourceList_FindIndexToSource(sourcelistp, sourcepath, collectionid, flags)
     TARGETSOURCELIST *sourcelistp;
     char *sourcepath;
     int collectionid;
     unsigned int flags;
{
  register unsigned  int i;
  register TARGETSOURCE *sp;

  Boolean FoundSource;
  int index;

  if (sourcelistp == NULL)
    {
      FatalError(E_BADTARGETSOURCELIST,
		 "Attempt to find source in NULL targetsourcelist.\n");
    }
  else if (TARGETSOURCELIST_NSources(sourcelistp) == 0)
    index = -1;
  else
    {
      i = 0; FoundSource = FALSE; index = -1;
      while ((PROGRAM_ErrorNo == E_NULL)
	     && (i < TARGETSOURCELIST_NSources(sourcelistp))
	     && !FoundSource)
	{
	  sp = TARGETSOURCELIST_Source(sourcelistp, i);
	  if ((String_Comparator(TARGETSOURCE_Path(sp), sourcepath) == 0)
	      && (TARGETSOURCE_CollectionId(sp) == collectionid))
	    { FoundSource = TRUE; index = i; }
	  i++;
	}
    }

  if ((index < 0) && !(flags & TDB_LAX))
    {
      FatalError(E_BADTARGETSOURCEPATH,
		 "Could not find source %s in targetsourcelist failed.\n",
		 sourcepath);
    }

  return (PROGRAM_ErrorNo == E_NULL) ? index : -1;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/TargetDB/RCS/SourceList_Find.c,v $ */
