/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: SourceListUtil.c,v 1.5 1994/10/12 19:45:58 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"



TARGETSOURCELIST *
SourceList(sourcelistp)
     TARGETSOURCELIST *sourcelistp;
{
  register unsigned int i;

  TARGETSOURCELIST *newsourcelistp;

  if (sourcelistp == NULL) {
    FatalError(E_BADTARGETSOURCELIST,
	       "Attempt to recreate NULL targetsourcelist.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL)
    newsourcelistp = (TARGETSOURCELIST *) emalloc(sizeof(TARGETSOURCELIST));
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETSOURCELIST_NSources(newsourcelistp)
      = TARGETSOURCELIST_NSources(sourcelistp);
    TARGETSOURCELIST_SourceArray(newsourcelistp) =
      (TARGETSOURCE **) emalloc(TARGETSOURCELIST_NSources(sourcelistp)
				* sizeof(TARGETSOURCE *));
    for (i = 0;
	 ((PROGRAM_ErrorNo == E_NULL)
	  && (i < TARGETSOURCELIST_NSources(newsourcelistp)));
	 i++) {
      TARGETSOURCELIST_Source(newsourcelistp, i)
	= TargetSource(TARGETSOURCELIST_Source(sourcelistp, i));
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newsourcelistp : NULL;
}



TARGETSOURCELIST *
SourceList_SubList(sourcelistp, begin, end)
     TARGETSOURCELIST *sourcelistp;
     int begin, end;
{
  register unsigned int i;

  TARGETSOURCELIST *newsourcelistp;

  if (sourcelistp == NULL) {
    FatalError(E_BADTARGETSOURCELIST,
	       "Attempt to get sublist from NULL targetsourcelist.\n");
  }
  if ((begin < 0) || (end < 0) || (begin > end)) {
    FatalError(E_BADRANGE,
	       "Bad range to get sublist from targetsourcelist.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL)
    newsourcelistp = (TARGETSOURCELIST *) emalloc(sizeof(TARGETSOURCELIST));
  if (PROGRAM_ErrorNo == E_NULL) {
    TARGETSOURCELIST_NSources(newsourcelistp) = end - begin + 1;
    TARGETSOURCELIST_SourceArray(newsourcelistp) =
      (TARGETSOURCE **) emalloc(TARGETSOURCELIST_NSources(sourcelistp)
				* sizeof(TARGETSOURCE *));
    for (i = 0;
	 ((PROGRAM_ErrorNo == E_NULL)
	  && (i < TARGETSOURCELIST_NSources(newsourcelistp)));
	 i++) {
      TARGETSOURCELIST_Source(newsourcelistp, i)
	= TargetSource(TARGETSOURCELIST_Source(sourcelistp, begin + i));
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newsourcelistp : NULL;
}


STRINGSET *
TargetSourceList_PathSet(sourcelist)
     TARGETSOURCELIST *sourcelist;
{
  register int i;
  register TARGETSOURCE *sp;

  STRINGSET *pathset = NULL;

  if (sourcelist != NULL) {
    for (i = 0;
	 (i < TARGETSOURCELIST_NSources(sourcelist))
	 && (PROGRAM_ErrorNo == E_NULL);
	 i++) {
      sp = TARGETSOURCELIST_Source(sourcelist, i);
      while (sp != NULL) {
	pathset = StringSet_AddString(pathset, TARGETSOURCE_Path(sp));
	sp = TARGETSOURCE_SecondarySource(sp);
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? pathset : NULL;
}



void 
SourceList_Free(sourcelistp)
     TARGETSOURCELIST *sourcelistp;
{
  register unsigned int i;

  if (sourcelistp == NULL) {
    FatalError(E_BADTARGETSOURCELIST,
	       "Attempt to to free NULL targetsourcelist.\n");
  } else {
    for (i = 0;
	 (PROGRAM_ErrorNo == E_NULL)
	 && (i < TARGETSOURCELIST_NSources(sourcelistp));
	 i++) {
      TargetSource_Free(TARGETSOURCELIST_Source(sourcelistp, i));
    }
    (void) free(TARGETSOURCELIST_SourceArray(sourcelistp));
    (void) free(sourcelistp);
  }

  return;
}

/* $Source: /afs/andrew/system/src/local/depot2/014/src/lib/TargetDB/RCS/SourceListUtil.c,v $ */
