/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: PreferenceDBUtil.c,v 1.13 1994/12/16 21:16:15 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"


/* This function returns the answer to:
 *      Does collectionname1 override collectionname2 
 */
Boolean 
PreferenceDB_Override(collectionname1, collectionname2, preferencedbp)
     char *collectionname1, *collectionname2;
     PREFERENCEDB *preferencedbp;
{
  STRINGSET *values1=NULL, *values2=NULL;
  static STRINGSET *wilditems;
  static int setwild = 1;

  if (preferencedbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database.\n");
  }

  if (strcmp(collectionname1, collectionname2) == 0) 
    return FALSE;

  values1 = Preference_GetStringSet(preferencedbp, collectionname1, 
				    "override", NULL, 
				    0 /* don't allocate space for the return value */);

  

  if (PROGRAM_ErrorNo != E_NULL) 
    return FALSE;

  /* override n1 n2 */
  if (StringSet_Member(values1, collectionname2))
    goto done;

  /* override n1 * */
  if (StringSet_Member(values1, PREF_WILDITEM))
    goto done;

  if (setwild) {
    wilditems = Preference_GetStringSet(preferencedbp, PREF_WILDITEM,
				      "override", NULL, 
				      0 /* don't allocate space for the return value */);
    setwild = 0;

    if (PROGRAM_ErrorNo != E_NULL)
      return FALSE;
  }

  /* override * n2 */
  if (!StringSet_Member(wilditems, collectionname2)) {
    return FALSE;
  }

done:
/* ok so now we think that c1 overrides c2. Let's make sure the converse isn't true */
    values2 = Preference_GetStringSet(preferencedbp, collectionname2, 
				    "override", NULL, 
				    0 /* don't allocate space for the return value */);
  if (StringSet_Member(values2, collectionname1)) {
    FatalError(E_BADPREFERENCEDB, "Circular overrides detected between collections: %s %s\n",
	       collectionname1, collectionname2);
    return FALSE;
  }

  return TRUE;
}


char *
PreferenceDB_CollectionInstallMethod(collectionname, preferencedbp)
     char *collectionname;
     PREFERENCEDB *preferencedbp;
{
  STRINGSET *CopyCollectionSet, *LinkCollectionSet;
  static Boolean copyall = 0;
  static Boolean init = 1;
  static char *COPYSTRING = "copy";
  static char *LINKSTRING = "link";
  

  if (preferencedbp == NULL) {
    FatalError(E_BADPREFERENCEDB,
	       "Attempt to search NULL preference database.\n");
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    CopyCollectionSet = Preference_GetStringSet(preferencedbp,
						COPYSTRING,
						"collection.installmethod",
						NULL,
						0 /* don't allocate space */);
  }
  if (StringSet_Member(CopyCollectionSet, collectionname)) 
    return COPYSTRING;

  LinkCollectionSet = Preference_GetStringSet(preferencedbp,
					      LINKSTRING,
					      "collection.installmethod",
					      NULL,
					      0 /* don't allocate space */);
  if (StringSet_Member(LinkCollectionSet, collectionname))
    return LINKSTRING;

  if (init) {
    if (StringSet_Member(CopyCollectionSet, "*")) {
      copyall = 1;
    }
    if (StringSet_Member(LinkCollectionSet, "*")) {
      /* copyall is initialized to 0 so this should only be triggered if the above
       * conditional was met and copyall was set to 1.
       */
      if (copyall) {
	FatalError(E_BADPREFERENCEDB, 
		   "Invalid preference database. Cannot specify '*' for both link and copy in collection.installmethod\n");
      }
    }
    
    init = 0;
  }

  return copyall ? COPYSTRING : LINKSTRING;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/017/src/lib/Preference/RCS/PreferenceDBUtil.c,v $ */
