/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: HintDB_GetHint.c,v 1.7 1994/10/27 20:50:26 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"


/*
 * Search hint database for hint info for the last subtree on path
 */
HINT *
HintDB_GetHint(hintdb, path)
     HINTDB hintdb;
     char *path;
{
  register HINTDB hpp;
  HINT *hintp;

  register Boolean LocatedHint, ContinueLooking;
  register int Comparison;

  LocatedHint = FALSE;
  hintp = NULL;
  if (hintdb == NULL) {
    return NULL;
  }
  LocatedHint = FALSE;
  ContinueLooking = TRUE;
  hpp = hintdb;
  while ((PROGRAM_ErrorNo == E_NULL) 
	 && !LocatedHint && ContinueLooking && (*hpp != NULL)) {
    if (HINT_PathName(*hpp) == NULL) {
      FatalError(E_BADHINTNAME,
		 "No name found for hint in hint database.\n");
    } else {
      Comparison = strcmp(HINT_PathName(*hpp), path);
      if (Comparison == 0) {
	LocatedHint = TRUE;
	hintp = *hpp;
      } else if (Comparison > 0) {
	ContinueLooking = FALSE;
      }
      hpp++;
    }
  }

  return (LocatedHint && (PROGRAM_ErrorNo == E_NULL)) ? hintp : NULL;
}
/* $Source: /afs/andrew/system/src/local/depot2/015/src/lib/Hint/RCS/HintDB_GetHint.c,v $ */
