/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef _DEPOT_FILE_H
#define _DEPOT_FILE_H

/* $Id: File.h,v 1.8 1994/11/10 20:19:01 ww0r Exp $ 
 *
 * Author: Sohan C. Ramakrishna Pillai
 */

typedef struct FileStat
{
  short type;
  unsigned short nlinks;
  mode_t mode;
  uid_t uid;
  gid_t gid;
  off_t size;
  time_t mtime;
  ino_t ino;
} FILESTAT;

#define FILESTAT_Type(fsp) ((fsp)->type)
#define FILESTAT_Mode(fsp) ((fsp)->mode)
#define FILESTAT_NLinks(fsp) ((fsp)->nlinks)
#define FILESTAT_Uid(fsp) ((fsp)->uid)
#define FILESTAT_Gid(fsp) ((fsp)->gid)
#define FILESTAT_Size(fsp) ((fsp)->size)
#define FILESTAT_MTime(fsp) ((fsp)->mtime)
#define FILESTAT_INode(fsp) ((fsp)->ino)

#define F_NUL	0x00
#define F_REG	0x01
#define F_LNK	0x02
#define F_DIR	0x04

#define FSTAT_NULL	0x000
#define FSTAT_MTIME	0x001
#define FSTAT_GROUP	0x002
#define FSTAT_OWNER	0x004 
#define FSTAT_MODE	0x008
#define FSTAT_STICKY	0x010	/* not really used, just a filler -- Sohan */
#define FSTAT_SETGID	0x020
#define FSTAT_SETUID	0x040

#define FSTATMODE_SETUID	S_ISUID
#define FSTATMODE_SETGID	S_ISGID

#define FSTATMODE_EXEC	(S_IXUSR|S_IXGRP|S_IXOTH)

extern int	File_Copy();
extern int	File_CreateDirectory ();
extern int	File_CreateLink();
extern int	File_CreateSymLink();
extern int	File_GetStatus();
extern int	File_ListDirectory();
extern int	File_ListMatchesinDirectory();
extern int	File_Move();
extern int	File_ReadSymLink();
extern int	File_RemoveDirectory();
extern int	File_RemovePath();
extern int	File_SetStatus();
extern int      File_Filter();
#endif /* _DEPOT_FILE_H */
/* $Source: /afs/andrew/system/src/local/depot2/016/src/lib/FileOps/RCS/File.h,v $ */
