/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef _DEPOT_DEPOTCONF_H
#define _DEPOT_DEPOTCONF_H

/* $Id: DepotConf.h,v 1.3 1994/08/12 13:47:16 ww0r Exp $ 
 *
 * Author: Sohan C. Ramakrishna Pillai
 */

typedef struct DepotConf
{
  char *collection_name;
  unsigned short spec;
  STRINGARRAY *confvalues;
} DEPOTCONF;

typedef DEPOTCONF **DEPOTCONFDB;


#define DEPOTCONF_CollectionName(dcp) ((dcp)->collection_name)
#define DEPOTCONF_Spec(dcp) ((dcp)->spec)
#define DEPOTCONF_ConfValue(dcp) ((dcp)->confvalues)

#define DEPOTCONFDB_Info(dbp) ((dbp)->info)
#define DEPOTCONFDB_Next(dbp) ((dbp)->next)

#define DC_UNKNOWN	0x00
#define DC_MAP		0x01
#define DC_DELETE	0x02
#define DC_COMMAND	0x04
#define DC_DELETECOMMAND 0x08

#define DEPOTCONF_WILDITEM	"*"

extern unsigned short DepotConf_SpecType();
extern char *DepotConf_SpecString();
extern int CollectionDepotConfDB_Write();
extern int GlobalDepotConfDB_Write();
extern DEPOTCONFDB *GlobalDepotConfDB_Read();
extern DEPOTCONFDB *CollectionDepotConfDB_Read();
extern DEPOTCONFDB *DepotConfDB_Map();
extern DEPOTCONFDB *DepotConfDB_Delete();
extern DEPOTCONFDB *DepotConfDB_Command();
extern DEPOTCONFDB *DepotConfDB_DeleteCommand();

extern DEPOTCONFDB *GlobalDepotConf_ExtractCollectionDepotConf();
extern DEPOTCONFDB *CollectionDepotConf_AppendGlobalDepotConf();

extern Boolean DepotConfDB_Comparator();
extern int DepotConfDB_Size();
extern DEPOTCONFDB *DepotConfDB();

extern STRINGSET *DepotConfDB_GetCommandList();

#endif /* _DEPOT_DEPOTCONF_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotConf/RCS/DepotConf.h,v $ */



