/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: CollectionListUtil.c,v 1.6 1994/08/12 03:27:33 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"


Boolean CollectionList_Comparator(clist1, clist2)
     COLLECTIONLIST *clist1, *clist2;
{
  register unsigned int i1, i2;
  register COLLECTION *cp1, *cp2;

  COLLECTIONLIST *tempclist;
  Boolean Comparison;

  if ((COLLECTIONLIST_Size(clist1) == 0)
      || (COLLECTIONLIST_Size(clist2) == 0))
    {
      if ((COLLECTIONLIST_Size(clist1) == 0)
	  && (COLLECTIONLIST_Size(clist2) == 0))
	Comparison = TRUE;
      else
	Comparison = FALSE;
    }
  else if ((COLLECTIONLIST_CollectionArray(clist1) == NULL)
	   || (COLLECTIONLIST_CollectionArray(clist2) == NULL))
    {
      FatalError(E_BADCOLLECTIONLIST,
		 "NULL collection list found unexpectedly.\n");
    }
  else
    {
      /* let clist1 be the smaller list */
      if (COLLECTIONLIST_Size(clist1) > COLLECTIONLIST_Size(clist2))
	{ tempclist = clist1; clist1 = clist2; clist2 = tempclist; }

      i1 = 0; i2 = 0; Comparison = TRUE;
      while ( (i1 < COLLECTIONLIST_Size(clist1))
	     && (PROGRAM_ErrorNo == E_NULL))
	{
	  cp1 = COLLECTIONLIST_Collection(clist1, i1);
	  cp2 = COLLECTIONLIST_Collection(clist2, i2);
	  if (((cp1 == NULL) || (COLLECTION_Status(cp1) & (C_IGNORE|C_DELETE)))
	      || ((cp2 == NULL) || (COLLECTION_Status(cp2) & (C_IGNORE|C_DELETE))))
	    {
	      if (((cp1 == NULL) || (COLLECTION_Status(cp1) & (C_IGNORE|C_DELETE)))
		  && ((cp2 == NULL) || (COLLECTION_Status(cp2) & (C_IGNORE|C_DELETE))))
		Comparison = TRUE;
	      else
		Comparison = FALSE;
	    }
	  else
	    {
	      if (String_Comparator(COLLECTION_Name(cp1),
				    COLLECTION_Name(cp2)) == FALSE)
		Comparison = FALSE;
	      else if (String_Comparator(COLLECTION_Path(cp1),
					 COLLECTION_Path(cp2)) == FALSE)
		Comparison = FALSE;
	      else if (COLLECTION_MapMethod(cp1) != COLLECTION_MapMethod(cp2))
		Comparison = FALSE;
	      else if (HintDB_Comparator(COLLECTION_HintDB(cp1),
					 COLLECTION_HintDB(cp2)) == FALSE)
		Comparison = FALSE;
	      else if (DepotConfDB_Comparator(COLLECTION_DepotConfDB(cp1),
					      COLLECTION_DepotConfDB(cp2))
		       == FALSE)
		Comparison = FALSE;
	      else if (StringArray_Comparator(COLLECTION_CommandList(cp1),
					      COLLECTION_CommandList(cp2)) != 0)
		Comparison = FALSE;
	      else
		Comparison = TRUE;
	    }
	  i1++, i2++;
	}
      /* check to see if any extra relevant collections exist in clist2 */
      i2 = COLLECTIONLIST_Size(clist1);
      while ((i2 < COLLECTIONLIST_Size(clist2)) && (PROGRAM_ErrorNo == E_NULL))
	{
	  cp2 = COLLECTIONLIST_Collection(clist2, i2);
	  if ((cp2 != NULL)
	      && !(COLLECTION_Status(cp2) & (C_IGNORE|C_DELETE)))
	    Comparison = FALSE;
	  i2++;
	}
    }
  return (PROGRAM_ErrorNo == E_NULL) ? Comparison : FALSE;
}


COLLECTIONLIST *CollectionList(clist)
     COLLECTIONLIST *clist;
{
  register unsigned int i;
  register COLLECTION *cp1, *cp2;
  COLLECTIONLIST *newclist;

  newclist = (COLLECTIONLIST *)emalloc(sizeof(COLLECTIONLIST));
  if (PROGRAM_ErrorNo == E_NULL)
    {
      if (clist == NULL)
	{
	  COLLECTIONLIST_Size(newclist) = 0;
	  COLLECTIONLIST_CollectionArray(newclist) = NULL;
	}
      else
	{
	  COLLECTIONLIST_Size(newclist) = COLLECTIONLIST_Size(clist);
	  COLLECTIONLIST_CollectionArray(newclist)
	    = (COLLECTION**)ecalloc(COLLECTIONLIST_Size(newclist) + 1,
				    sizeof(COLLECTION *));
	}
    }

  if (clist != NULL)
    {
      for (i = 0;
	   (i < COLLECTIONLIST_Size(clist)) && (PROGRAM_ErrorNo == E_NULL);
	   i++)
	{
	  cp1 = COLLECTIONLIST_Collection(clist, i);
	  if (cp1 != NULL)
	    {
	      cp2 = (COLLECTION *)emalloc(sizeof(COLLECTION));
	      if (PROGRAM_ErrorNo == E_NULL)
		{
		  if (COLLECTION_Name(cp1) == NULL)
		    COLLECTION_Name(cp2) = NULL;
		  else
		    COLLECTION_Name(cp2) = String(COLLECTION_Name(cp1),
						  strlen(COLLECTION_Name(cp1)));
		}
	      if (PROGRAM_ErrorNo == E_NULL)
		{ COLLECTION_MapMethod(cp2) = COLLECTION_MapMethod(cp1); }
	      if (PROGRAM_ErrorNo == E_NULL)
		{
		  COLLECTION_Id(cp2) = i;
		  COLLECTION_Path(cp2) = NULL;
		  COLLECTION_HintDB(cp2) = NULL;
		  COLLECTION_Image(cp2) = NULL;
		  COLLECTION_DepotConfDB(cp2) = NULL;
		  COLLECTION_CommandList(cp2) = NULL;
		  COLLECTION_TargetDB(cp2) = NULL;
		  COLLECTION_Status(cp2) = 0;
		  COLLECTIONLIST_Collection(newclist, i) = cp2;
		}
	    }
	  else
	    { COLLECTIONLIST_Collection(newclist, i) = NULL; }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newclist : NULL;
}


COLLECTIONLIST *CollectionList_AddCollectionName(clist,
						 collectionname,
						 possiblynonexistent)
     COLLECTIONLIST *clist;
     char *collectionname;
     Boolean possiblynonexistent;
{
  register unsigned int i;
  register COLLECTION *cp;
  int emptyslot; /* -ve emptyslot => no empty slots in collectionlist */
  Boolean PreExistingCollection;
  COLLECTIONLIST *newclist;

  if (collectionname == NULL)
    {
      FatalError(E_NULLCOLLECTIONNAME,
		 "Attempt to add NULL name to collection list.\n");
    }
  else
    {
      newclist = clist;
      if (newclist == NULL)
	{
	  newclist = (COLLECTIONLIST *)emalloc(sizeof(COLLECTIONLIST));
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      COLLECTIONLIST_Size(newclist) = 0;
	      COLLECTIONLIST_CollectionArray(newclist) = NULL;
	    }
	}
      emptyslot = -1;
      i = 0; PreExistingCollection = FALSE;
      while ( (PROGRAM_ErrorNo == E_NULL)
	     && (i < COLLECTIONLIST_Size(newclist))
	     && (PreExistingCollection == FALSE))
	{
	  cp = COLLECTIONLIST_Collection(newclist, i);
	  if (cp == NULL)
	    emptyslot = (int)i;
	  else if (String_Comparator(collectionname, COLLECTION_Name(cp)) == 0)
	    {
	      PreExistingCollection = TRUE;
	      if (!possiblynonexistent)
		{ COLLECTION_Status(cp) &= ~C_POSSIBLYNONEXISTENT; }
	    }
	  i++;
	}

      if ((PreExistingCollection == FALSE) && (PROGRAM_ErrorNo == E_NULL))
	{
	  if (emptyslot < 0)
	    {
	      /* no empty slot found; enlarge list and use last slot */
	      emptyslot = COLLECTIONLIST_Size(newclist);
	      COLLECTIONLIST_Size(newclist)++;
	      if (COLLECTIONLIST_Size(newclist) == 1)
		COLLECTIONLIST_CollectionArray(newclist)
		  = (COLLECTION **)emalloc((COLLECTIONLIST_Size(newclist)+1)
					   *(sizeof(COLLECTION *)));
	      else
		COLLECTIONLIST_CollectionArray(newclist)
		  = (COLLECTION **)
		    erealloc((void *)COLLECTIONLIST_CollectionArray(newclist),
			     (COLLECTIONLIST_Size(newclist)+1)
			     *(sizeof(COLLECTION *)));
	      COLLECTIONLIST_Collection(newclist, COLLECTIONLIST_Size(newclist))
		= NULL;
	    }
	  if (PROGRAM_ErrorNo == E_NULL)
	    cp  = (COLLECTION *)emalloc(sizeof(COLLECTION));
	  if (PROGRAM_ErrorNo == E_NULL)
	    COLLECTION_Name(cp) = String(collectionname,
					 strlen(collectionname));
	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      COLLECTION_Id(cp) = (unsigned int)emptyslot;
	      COLLECTION_Path(cp) = NULL;
	      COLLECTION_MapMethod(cp) = U_MAP;
	      COLLECTION_HintDB(cp) = NULL;
	      COLLECTION_Image(cp) = NULL;
	      COLLECTION_DepotConfDB(cp) = NULL;
	      COLLECTION_CommandList(cp) = NULL;
	      COLLECTION_TargetDB(cp) = NULL;
	      COLLECTION_Status(cp) =
		possiblynonexistent ? C_POSSIBLYNONEXISTENT : 0;
	      COLLECTIONLIST_Collection(newclist, emptyslot) = cp;
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newclist : NULL;
}



char **CollectionNameList(clist)
     COLLECTIONLIST *clist;
{
  register unsigned int i;
  register COLLECTION *cp;
  register char **np;

  char **namelist;

  if (clist == NULL)
    { namelist = NULL; }
  else
    {
      namelist = (char **)emalloc(COLLECTIONLIST_Size(clist) * sizeof(char *));
      if (PROGRAM_ErrorNo == E_NULL)
	{
	  for (i = 0;
	       (PROGRAM_ErrorNo == E_NULL) && (i < COLLECTIONLIST_Size(clist));
	       i++)
	    {
	      cp = COLLECTIONLIST_Collection(clist, i);
	      np = namelist+i;
	      if ((cp == NULL) || COLLECTION_Name(cp) == NULL)
		{ *np = NULL; }
	      else
		{
		  *np = String(COLLECTION_Name(cp),
			       strlen(COLLECTION_Name(cp)));
		}
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? namelist : NULL;
}


      
char **CollectionPathList(clist)
     COLLECTIONLIST *clist;
{
  register unsigned int i;
  register COLLECTION *cp;
  register char **pp;

  char **pathlist;

  if (clist == NULL)
    { pathlist = NULL; }
  else
    {
      pathlist = (char **)emalloc(COLLECTIONLIST_Size(clist) * sizeof(char *));
      if (PROGRAM_ErrorNo == E_NULL)
	{
	  for (i = 0;
	       (PROGRAM_ErrorNo == E_NULL) && (i < COLLECTIONLIST_Size(clist));
	       i++)
	    {
	      cp = COLLECTIONLIST_Collection(clist, i);
	      pp = pathlist+i;
	      if ((cp == NULL) || COLLECTION_Name(cp) == NULL)
		{ *pp = NULL; }
	      else
		{
		  *pp = String(COLLECTION_Path(cp),
			       strlen(COLLECTION_Path(cp)));
		}
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? pathlist : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/CollectionList/RCS/CollectionListUtil.c,v $ */
