/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Collection_TargetSourceFromFileStatus.c,v 1.7 1994/10/25 20:31:20 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"


TARGETSOURCE *
Collection_TargetSourceFromFileStatus(filestatus,
				      source,
				      collectionp)
     FILESTAT *filestatus;
     char *source;
     COLLECTION *collectionp;
{
  unsigned update_spec;

  TARGETSOURCE *targetsourcep = NULL;

  if (collectionp == NULL) {
    FatalError(E_NULLCOLLECTION,
	       "Attempt to create target source for NULL collection\n");
  }
  if (filestatus == NULL) {
    FatalError(E_BADFILESTATUSINFO,
	       "Attempt to create targetsource with NULL filestatus info in collection: %s\n",
	       COLLECTION_Name(collectionp));
  }
  if (source == NULL) {
    FatalError(E_BADTARGETSOURCEPATH,
	       "Attempt to create targetsource with NULL source path in collection: %s\n",
	       COLLECTION_Name(collectionp));
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (FILESTAT_Type(filestatus) & F_REG) {
      update_spec = (U_MAP | COLLECTION_MapMethod(collectionp));
    } else if (FILESTAT_Type(filestatus) & F_LNK) {
      update_spec = (U_MAP | COLLECTION_MapMethod(collectionp));
    } else if (FILESTAT_Type(filestatus) & F_DIR) {
      update_spec = (U_MKDIR | COLLECTION_MapMethod(collectionp));
    } else if (FILESTAT_Type(filestatus) == F_NUL) {
      FatalError(E_BADFILESTATUSTYPE, 
		 "Invalid file specification: File not found. File: %s\tCollection: %s\n",
		 source, COLLECTION_Name(collectionp));
    } else {
      FatalError(E_BADFILESTATUSTYPE,
		 "Unknown filestatus found. File:%s\tCollection: %s\n",
		 source, COLLECTION_Name(collectionp));
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    targetsourcep = TargetSource_Create(source,
					update_spec,
					COLLECTION_Id(collectionp),
					S_NULL,
					U_NULL /* update_spec_old */ ,
					NULL);
  }
  return (PROGRAM_ErrorNo == E_NULL) ? targetsourcep : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/Collection_TargetSourceFromFileStatus.c,v $ */
