/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Collection_FSImageMap.c,v 1.7 1995/02/09 18:13:06 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"

/* stuff to check for hard links etc. */
/* $$$NOTE$$$
 * look for a way to combine this with secondary source computation in
 * Collection_PathMap.c
 */
typedef struct secondarysource {
  char *linkid;
  TARGETSOURCE *source;
  struct secondarysource *next;
} SECONDARYSOURCEINFO, *SECONDARYSOURCELIST;

static SECONDARYSOURCEINFO *SecondarySourceList_IncludeSource();
static void SecondarySourceList_Free();

static TARGETDB *Collection_FSImageSubTreeMap();


TARGETDB *
Collection_FSImageMap(targetdbp,
		      source,
		      target,
		      collectionp,
		      hintdb_old)
     TARGETDB *targetdbp;
     char *source, *target;
     COLLECTION *collectionp;
     HINTDB hintdb_old;
{
  register FILESYSTEMIMAGE *ip;
  register SECONDARYSOURCEINFO *ssp;
  register TARGETSOURCE *sp;

  TARGETDB *newtargetdbp;

  TARGETDB *targetdbnodep;
  FILESYSTEMIMAGE *fsimagenodep;
  TARGETSOURCE *targetsourcep;
  int locatedsourceindex;
  TARGETSOURCE *locatedtargetsourcep;
  HINT *oldhint, *newhint;
  Boolean HintComparison;
  int targetdbchildslot;
  TARGETDB *targetdbchildp;
  TARGETDB **targetdbchildpp;
  char childsource[MAXPATHLEN];
  SECONDARYSOURCEINFO *secondarysourcelist;


  if (collectionp == NULL) {
    FatalError(E_NULLCOLLECTION,
	       "Attempt to generate mappings for a NULL collection.\n");
  }
  if (COLLECTION_Image(collectionp) == NULL) {
    FatalError(E_BADCOLLECTION,
	     "Attempt to map from NULL file system image of collection.\n");
  }
  if (source == NULL) {
    FatalError(E_NULLSOURCE,
	       "Attempt to map from NULL source for collection.\n");
  }
  if (target == NULL) {
    FatalError(E_NULLTARGET,
	       "Attempt to map to NULL target for collection.\n");
  }
  /* 
   * Create non-virgin branch in targetdbp to specified target,
   * except that the leaf is not to be marked as nonvirgin. Source info for the
   * leaf comes from the node of file system image corresponding to source.
   */
  if (PROGRAM_ErrorNo == E_NULL)
    newtargetdbp = Collection_TargetDBCreateNonVirginPath(targetdbp,
							  source, target,
							  collectionp);
  if (PROGRAM_ErrorNo == E_NULL)
    targetdbnodep = TargetDB_LocateNode(newtargetdbp, target, TDB_LOCATE);
  if (PROGRAM_ErrorNo == E_NULL)
    fsimagenodep = FileSystemImage_LocateNode(COLLECTION_Image(collectionp),
					      source, COLLECTION_Name(collectionp));

  /* add source to targetdbnodep -- unless it is the root node */
  if (PROGRAM_ErrorNo == E_NULL) {
    if (String_Comparator(TARGETDB_Name(targetdbnodep), "/") == 0) {
      if (!(FILESYSTEMIMAGE_Type(fsimagenodep) & FS_DIR)) {
	FatalError
	  (E_BADTARGETSOURCEPATH,
	   "Attempt to map non-directory file %s to target directory.\n",
	   source);
      }
    } else {
      targetsourcep = Collection_TargetSourceFromFSImage(fsimagenodep,
							 source,
							 collectionp);
      if (PROGRAM_ErrorNo == E_NULL)
	TARGETDB_SourceList(targetdbnodep) =
	  Collection_SourceList_AddSource
	  (TARGETDB_SourceList(targetdbnodep), targetsourcep, collectionp);

      if (PROGRAM_ErrorNo == E_NULL)
	TargetSource_Free(targetsourcep);
    }
  }
  /* 
   * if depotconf specifications haven't changed since last run,
   * check if old hints and new hints match
   */
  HintComparison = FALSE;
  if ((PROGRAM_ErrorNo == E_NULL)
      && !(COLLECTION_Status(collectionp) & C_DEPOTCONFCHANGE)
      && (hintdb_old != NULL)
      && (COLLECTION_HintDB(collectionp) != NULL)) {
    oldhint = HintDB_GetHint(hintdb_old, source);
    if ((PROGRAM_ErrorNo == E_NULL) && (oldhint != NULL)) {
      newhint = HintDB_GetHint(COLLECTION_HintDB(collectionp), source);
      if ((PROGRAM_ErrorNo == E_NULL) && (newhint != NULL))
	HintComparison = Hint_Comparator(oldhint, newhint);
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (HintComparison == TRUE) {
      /* mark source to targetdbnodep as enduring subtree */
      locatedsourceindex =
	SourceList_FindIndexToSource(TARGETDB_SourceList(targetdbnodep),
				     source,
				     COLLECTION_Id(collectionp),
				     TDB_LOCATE);
      if ((PROGRAM_ErrorNo == E_NULL) && (locatedsourceindex >= 0)) {
	locatedtargetsourcep =
	  TARGETSOURCELIST_Source(TARGETDB_SourceList(targetdbnodep),
				  locatedsourceindex);
	TARGETDB_Status(locatedtargetsourcep) |= S_ENDURINGSUBTREE;
	TARGETDB_UpdateSpec(locatedtargetsourcep)
	  |= COLLECTION_MapMethod(collectionp);
      }
    } else if (FILESYSTEMIMAGE_Type(fsimagenodep) & FS_DIR) {
      secondarysourcelist = NULL;
      /* recursively map children, if any, of fsimagenodep */
      for (ip = FILESYSTEMIMAGE_Child(fsimagenodep);
	   (PROGRAM_ErrorNo == E_NULL) && (ip != NULL);
	   ip = FILESYSTEMIMAGE_Next(ip)) {
	if (FILESYSTEMIMAGE_Name(ip) == NULL) {
	  FatalError(E_BADIMAGEPATHNAME,
		     "Attempt to map from fsimage with NULL name.\n");
	}
	/* compute new source for child nodes */
	if (PROGRAM_ErrorNo == E_NULL) {
	  if (strcmp(source, "/") == 0)
	    (void) strcpy(childsource, FILESYSTEMIMAGE_Name(ip));
	  else
	    (void) sprintf(childsource,
			   "%s/%s", source, FILESYSTEMIMAGE_Name(ip));
	}
	/* 
	 * locate slot for child node under targetdbnodep,
	 * creating it if necessary
	 */
	if (PROGRAM_ErrorNo == E_NULL) {
	  targetdbchildslot =
	    TargetDB_LocateIndexToChildNode(targetdbnodep,
					    FILESYSTEMIMAGE_Name(ip),
					    TDB_LOCATE | TDB_CREATE);
	  if (PROGRAM_ErrorNo == E_NULL) {
	    targetdbchildpp =
	      TARGETDB_Children(targetdbnodep) + targetdbchildslot;
	  }
	}
	/* 
	 * recursively map onto child slot of targetdbnodep
	 * from ip, the current child of fsimagenodep
	 */
	if (PROGRAM_ErrorNo == E_NULL) {
	  *targetdbchildpp =
	    Collection_FSImageSubTreeMap(*targetdbchildpp,
					 FILESYSTEMIMAGE_Name(ip),
					 childsource,
					 collectionp,
					 ip,
					 hintdb_old,
					 &secondarysourcelist);
	}
      }

      /* add secondary sources from from the secondarysourcelist */
      if (secondarysourcelist != NULL) {
	for (ssp = secondarysourcelist;
	     (PROGRAM_ErrorNo == E_NULL) && (ssp != NULL);
	     ssp = ssp->next) {
	  for (sp = ssp->source;
	       (PROGRAM_ErrorNo == E_NULL) && (sp != NULL);
	       sp = TARGETSOURCE_SecondarySource(sp)) {
	    if (strcmp(source, "/") == 0)
	      (void) strcpy(childsource, TARGETSOURCE_Path(sp));
	    else
	      (void) sprintf(childsource, "%s/%s",
			     source, TARGETSOURCE_Path(sp));
	    /* locate child corresponding to this source */
	    targetdbchildp =
	      TargetDB_LocateChildNode(targetdbnodep,
				       TARGETSOURCE_Path(sp),
				       TDB_LOCATE);
	    /* locate source corresponding to this node in child */
	    if (PROGRAM_ErrorNo == E_NULL) {
	      locatedsourceindex =
		SourceList_FindIndexToSource
		(TARGETDB_SourceList(targetdbchildp),
		 childsource,
		 COLLECTION_Id(collectionp),
		 TDB_LOCATE);
	    }
	    if ((PROGRAM_ErrorNo == E_NULL)
		&& (locatedsourceindex >= 0)) {
	      locatedtargetsourcep =
		TARGETSOURCELIST_Source
		(TARGETDB_SourceList(targetdbchildp),
		 locatedsourceindex);
	      TARGETSOURCE_SecondarySource(locatedtargetsourcep) =
		TargetSource(ssp->source);
	    }
	  }
	}
	/* free the secondarysourcelist */
	SecondarySourceList_Free(secondarysourcelist);
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}


static TARGETDB *
Collection_FSImageSubTreeMap(targetdbp,
			     nodename,
			     source,
			     collectionp,
			     fsimagep,
			     hintdb_old,
			     secondarysourcelistp)
     TARGETDB *targetdbp;
     char *nodename, *source;
     FILESYSTEMIMAGE *fsimagep;
     COLLECTION *collectionp;
     HINTDB hintdb_old;
     SECONDARYSOURCEINFO **secondarysourcelistp;
{
  register FILESYSTEMIMAGE *ip;
  register SECONDARYSOURCEINFO *ssp;
  register TARGETSOURCE *sp;

  TARGETDB *newtargetdbp;
  TARGETSOURCE *targetsourcep;
  int locatedsourceindex;
  TARGETSOURCE *locatedtargetsourcep;
  HINT *oldhint, *newhint;
  Boolean HintComparison;
  int targetdbchildslot;
  TARGETDB *targetdbchildp;
  TARGETDB **targetdbchildpp;
  char childsource[MAXPATHLEN];
  SECONDARYSOURCEINFO *childsecondarysourcelist;

  newtargetdbp = targetdbp;

  /* include possible secondary source in secondarysourcelistp */
  if (FILESYSTEMIMAGE_Type(fsimagep) & FS_HARDLNK) {
    *secondarysourcelistp =
      SecondarySourceList_IncludeSource(*secondarysourcelistp,
					nodename,
					FILESYSTEMIMAGE_Link(fsimagep),
					collectionp);
  }
  /* add source for newtargetdbp from the top level node of fsimagep */
  targetsourcep = Collection_TargetSourceFromFSImage(fsimagep,
						     source,
						     collectionp);
  if (PROGRAM_ErrorNo == E_NULL)
    TARGETDB_SourceList(newtargetdbp) =
      Collection_SourceList_AddSource(TARGETDB_SourceList(newtargetdbp),
				      targetsourcep, collectionp);

  if (PROGRAM_ErrorNo == E_NULL)
    TargetSource_Free(targetsourcep);

  /* 
   * if depotconf specifications haven't changed since last run,
   * check if old hints and new hints match
   */
  HintComparison = FALSE;
  if ((PROGRAM_ErrorNo == E_NULL)
      && !(COLLECTION_Status(collectionp) & C_DEPOTCONFCHANGE)
      && (hintdb_old != NULL)
      && (COLLECTION_HintDB(collectionp) != NULL)) {
    oldhint = HintDB_GetHint(hintdb_old, source);
    if ((PROGRAM_ErrorNo == E_NULL) && (oldhint != NULL)) {
      newhint = HintDB_GetHint(COLLECTION_HintDB(collectionp), source);
      if ((PROGRAM_ErrorNo == E_NULL) && (newhint != NULL))
	HintComparison = Hint_Comparator(oldhint, newhint);
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (HintComparison == TRUE) {
      /* mark source to newtargetdbp as enduring subtree */
      locatedsourceindex =
	SourceList_FindIndexToSource(TARGETDB_SourceList(newtargetdbp),
				     source,
				     COLLECTION_Id(collectionp),
				     TDB_LOCATE);
      if ((PROGRAM_ErrorNo == E_NULL) && (locatedsourceindex >= 0)) {
	locatedtargetsourcep =
	  TARGETSOURCELIST_Source(TARGETDB_SourceList(newtargetdbp),
				  locatedsourceindex);
	TARGETDB_Status(locatedtargetsourcep) |= S_ENDURINGSUBTREE;
	TARGETDB_UpdateSpec(locatedtargetsourcep)
	  |= COLLECTION_MapMethod(collectionp);
      }
    } else if (FILESYSTEMIMAGE_Type(fsimagep) & FS_DIR) {
      childsecondarysourcelist = NULL;
      /* recursively map children, if any, of fsimagep */
      for (ip = FILESYSTEMIMAGE_Child(fsimagep);
	   (PROGRAM_ErrorNo == E_NULL) && (ip != NULL);
	   ip = FILESYSTEMIMAGE_Next(ip)) {
	if (FILESYSTEMIMAGE_Name(ip) == NULL) {
	  FatalError(E_BADIMAGEPATHNAME,
		     "Attempt to map from fsimage with NULL name.\n");
	}
	/* compute new source for child nodes */
	if (PROGRAM_ErrorNo == E_NULL) {
	  (void) strcpy(childsource, source);
	  (void) strcat(childsource, "/");
	  (void) strcat(childsource, FILESYSTEMIMAGE_Name(ip));
	}
	/* 
	 * locate slot for child node under newtargetdb,
	 * creating it if necessary
	 */
	if (PROGRAM_ErrorNo == E_NULL) {
	  targetdbchildslot =
	    TargetDB_LocateIndexToChildNode(newtargetdbp,
					    FILESYSTEMIMAGE_Name(ip),
					    TDB_LOCATE | TDB_CREATE);
	  if (PROGRAM_ErrorNo == E_NULL) {
	    targetdbchildpp =
	      TARGETDB_Children(newtargetdbp) + targetdbchildslot;
	  }
	}
	/* 
	 * recursively map onto child slot of newtargetdbp
	 * from ip, the current child of fsimagep
	 */
	if (PROGRAM_ErrorNo == E_NULL) {
	  *targetdbchildpp = Collection_FSImageSubTreeMap(*targetdbchildpp,
					     FILESYSTEMIMAGE_Name(ip),
					     childsource,
					     collectionp,
					     ip,
					     hintdb_old,
					     &childsecondarysourcelist);
	}
      }

      /* add secondary sources from from the childsecondarysourcelist */
      if (childsecondarysourcelist != NULL) {
	for (ssp = childsecondarysourcelist;
	     (PROGRAM_ErrorNo == E_NULL) && (ssp != NULL);
	     ssp = ssp->next) {
	  for (sp = ssp->source;
	       (PROGRAM_ErrorNo == E_NULL) && (sp != NULL);
	       sp = TARGETSOURCE_SecondarySource(sp)) {
	    if (strcmp(source, "/") == 0)
	      (void) strcpy(childsource, TARGETSOURCE_Path(sp));
	    else
	      (void) sprintf(childsource, "%s/%s",
			     source, TARGETSOURCE_Path(sp));
	    /* locate child corresponding to this source */
	    targetdbchildp =
	      TargetDB_LocateChildNode(newtargetdbp,
				       TARGETSOURCE_Path(sp),
				       TDB_LOCATE);
	    /* locate source corresponding to this node in child */
	    if (PROGRAM_ErrorNo == E_NULL) {
	      locatedsourceindex =
		SourceList_FindIndexToSource
		(TARGETDB_SourceList(targetdbchildp),
		 childsource,
		 COLLECTION_Id(collectionp),
		 TDB_LOCATE);
	    }
	    if ((PROGRAM_ErrorNo == E_NULL)
		&& (locatedsourceindex >= 0)) {
	      locatedtargetsourcep =
		TARGETSOURCELIST_Source
		(TARGETDB_SourceList(targetdbchildp),
		 locatedsourceindex);
	      TARGETSOURCE_SecondarySource(locatedtargetsourcep) =
		TargetSource(ssp->source);
	    }
	  }
	}
	/* free the childsecondarysourcelist */
	SecondarySourceList_Free(childsecondarysourcelist);
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}



static SECONDARYSOURCEINFO *
SecondarySourceList_IncludeSource(secondarysourcelist,
				  name,
				  linkid,
				  collectionp)
     SECONDARYSOURCEINFO *secondarysourcelist;
     char *name, *linkid;
     COLLECTION *collectionp;
{
  register SECONDARYSOURCEINFO *ssp;
  register TARGETSOURCE *sp;

  SECONDARYSOURCEINFO *newsecondarysourcelist;

  TARGETSOURCE *targetsourcep;
  SECONDARYSOURCEINFO *locatedsecondarysourcep;
  Boolean LocatedSource;

  newsecondarysourcelist = secondarysourcelist;
  targetsourcep = TargetSource_Create(name,
				      (U_HARDLINK
				       | COLLECTION_MapMethod(collectionp)),
				      COLLECTION_Id(collectionp),
				      S_NULL,
				      U_NULL /* update_spec_old */ ,
				      NULL);

  LocatedSource = FALSE;
  ssp = newsecondarysourcelist;
  while (!LocatedSource && (ssp != NULL)) {
    if (String_Comparator(linkid, ssp->linkid) == 0) {
      locatedsecondarysourcep = ssp;
      LocatedSource = TRUE;
    } else {
      ssp = ssp->next;
    }
  }

  if (PROGRAM_ErrorNo == E_NULL) {
    if (LocatedSource) {
      sp = locatedsecondarysourcep->source;
      while (TARGETSOURCE_SecondarySource(sp) != NULL)
	sp = TARGETSOURCE_SecondarySource(sp);
      TARGETSOURCE_SecondarySource(sp) = targetsourcep;
    } else {			/* !LocatedSource */
      ssp = (SECONDARYSOURCEINFO *) emalloc(sizeof(SECONDARYSOURCEINFO));
      if (PROGRAM_ErrorNo == E_NULL) {
	ssp->linkid = String(linkid, strlen(linkid));
	ssp->source = targetsourcep;
	ssp->next = newsecondarysourcelist;
	newsecondarysourcelist = ssp;
	LocatedSource = TRUE;
      }
    }
  }
  return ((PROGRAM_ErrorNo == E_NULL)
	  && LocatedSource) ? newsecondarysourcelist : NULL;
}


static void 
SecondarySourceList_Free(secondarysourcelist)
     SECONDARYSOURCEINFO *secondarysourcelist;
{
  register SECONDARYSOURCEINFO *ssp1, *ssp2;

  ssp1 = secondarysourcelist;
  while (ssp1 != NULL) {
    ssp2 = ssp1->next;
    if (ssp1->linkid != NULL)
      String_Free(ssp1->linkid);
    if (ssp1->source != NULL)
      TargetSource_Free(ssp1->source);
    (void) free((void *) ssp1);
    ssp1 = ssp2;
  }

  return;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/Collection/RCS/Collection_FSImageMap.c,v $ */
