.\"
.\" $Header: /afs/andrew/system/src/local/depot2/009/RCS/DepotDB_Read.man,v 1.1 1993/09/20 21:22:43 sohan Exp $
.\" $Source: /afs/andrew/system/src/local/depot2/009/RCS/DepotDB_Read.man,v $
.\"
.\"/***********************************************************
.\"        Copyright 1991 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"******************************************************************/
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH DepotDB_Read 3
.SH Name
DepotDB_Read, DepotDB_ReadPreliminaryInfo,
DepotDB_PreferenceDB_Read, DepotDB_DepotConfDB_Read,
DepotDB_CollectionList_Read, DepotDB_TargetDB_Read
- read information in depot database using depot database handle
.SH Syntax
.nf
.B #include <util.h>
.B #include <Error.h>
.B #include <File.h>
.B #include <FileSystemImage.h>
.B #include <Preference.h>
.B #include <Hint.h>
.B #include <DepotDB.h>
.PP
.B DEPOTDB *DepotDB_Read(\fIdbh\fP)
.br
.B DEPOTDBHANDLE *\fIdbh\fP;
.PP
.B DEPOTDB *DepotDB_ReadPreliminaryInfo(\fIdbh\fP)
.br
.B DEPOTDBHANDLE *\fIdbh\fP;
.PP
.B PREFERENCEDB *DepotDB_PreferenceDB_Read(\fIdbh\fP)
.br
.B DEPOTDBHANDLE *\fIdbh\fP;
.PP
.B DEPOTCONFDB *DepotDB_DepotConfDB_Read(\fIdbh\fP)
.br
.B DEPOTDBHANDLE *\fIdbh\fP;
.PP
.B COLLECTIONLIST *DepotDB_CollectionList_Read(\fIdbh\fP)
.br
.B DEPOTDBHANDLE *\fIdbh\fP;
.PP
.B TARGETDB *DepotDB_TargetDB_Read(\fIdbh\fP)
.br
.B DEPOTDBHANDLE *\fIdbh\fP;
.fi
.SH Description
The
.PN DepotDB_Read
routine reads in the depot database associated with the depot database
handle \fIdbh\fP and returns a pointer to the database so read in.
.PP
The
.PN DepotDB_ReadPreliminaryInfo
routine is similar to the
.PN DepotDB_Read
routine with the exception being that instead of reading in the whole
depot database, only the preliminary information prior to the target database
is read in.
.PP
For both the
.PN DepotDB_Read
and the
.PN DepotDB_ReadPreliminaryInfo
routines, the preference, depot.conf database and collection list respectively
read in are accessible using the macros DEPOTDB_OldPreferenceDB(),
DEPOTDB_OldDepotConfDB() and DEPOTDB_OldCollectionList() respectively.
For the
.PN DepotDB_Read
routine, in addition to this, the target database read in
is accessible using the macro DEPOTDB_TargetDB().
.PP
The
.PN DepotDB_PreferenceDB_Read
,
.PN DepotDB_DepotConfDB_Read
,
.PN DepotDB_CollectionList_Read
and
.PN DepotDB_TargetDB_Read
routines respectively read in the preference, depot.conf database,
collection list and target database components respectively of the depot
database associated with the depot database handle \fIdbh\fP in a fashion similar to the
.PN DepotDB_Read
routine.
.SH Return Values
Upon successful completion, a pointer to the depot database or the component
of the depot database read in is
returned. If any error occurs, the global variable PROGRAM_ErrorNo is set and
a NULL value is returned.
.SH See Also
DepotDB_Open(3), DepotDB_Close(3), DepotDB_Write(3), DEPOTDB(7)
.SH Author
Sohan C. Ramakrishna-Pillai
