/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef _DEPOT_UTIL_H
#define _DEPOT_UTIL_H

/* $Id: util.h,v 1.12 1995/02/13 20:45:20 ww0r Exp $
*
* Author: Sohan C. Ramakrishna Pillai
 */


/* boolean constants */
#define TRUE    1
#define FALSE   0

typedef unsigned int Boolean;


typedef struct stringarray
{
  unsigned size;
  char **values;
} STRINGARRAY, STRINGSET, SENTENCE;

#define STRINGARRAY_Size(sp)	((sp)->size)
#define STRINGSET_Size(sp)	STRINGARRAY_Size(sp)
#define SENTENCE_Size(sp)	STRINGARRAY_Size(sp)
#define STRINGARRAY_Values(sp)	((sp)->values)
#define STRINGSET_Values(sp)	STRINGARRAY_Values(sp)
#define SENTENCE_Values(sp)	STRINGARRAY_Values(sp)
#define STRINGARRAY_String(sp,n) (*((sp)->values + \
				    (((n) < ((sp)->size)) ? \
				     (n) : ((sp)->size))))
#define STRINGSET_String(sp,n)	STRINGARRAY_String(sp,n)
#define SENTENCE_String(sp,n)	STRINGARRAY_String(sp,n)


/* file.c */
extern FILE *efopen();
extern FILE *efdopen();
extern unsigned efgetunsigned();
extern long efgetlong();
char *efgetstring();
extern int fdgetc();
extern int quotedfputs();

#define efgetushort(fp) ((unsigined short)efgetunsigned(fp))
#define efgetint(fp) ((int)efgetlong(fp))
#define efgetshort(fp) ((short)efgetshort(fp))

/* malloc.c */
extern void *emalloc();
extern void *ecalloc();
extern void *erealloc();

/* math.c */
extern long StringToNumber();

#define OctalNumber(s)		(StringToNumber(s, 8))
#define HexadecimalNumber(s)	(StringToNumber(s, 16))
#define Number(s)		(StringToNumber(s, 10))

/* misc.c */
extern char *strerror();

/* passwd.c */
extern int UserIDFromName();
extern int GroupIDFromName();

/* string.c */
extern char *String();
extern void String_Free();
extern int String_Comparator();
extern char *String_RemoveQuotes();
extern void String_Write();
extern STRINGARRAY *StringArray();
extern void StringArray_Free();
extern int StringArray_Size();
extern int StringArray_Comparator();
extern STRINGARRAY *StringArray_AppendString();
extern void StringArray_Write();
extern STRINGARRAY *StringToStringArray();
extern STRINGSET *StringSet_AddString();
extern Boolean StringSet_Member();
extern int StringSet_Index();
extern STRINGSET *StringSet_Merge();

#define StringSet(set, len)	((STRINGSET *)StringArray(set, len))
#define Sentence(set, len)	((SENTENCE *)StringArray(set, len))
#define StringSet_Free		StringArray_Free
#define Sentence_Free		StringArray_Free
#define StringSet_Size		StringArray_Size
#define Sentence_Size		StringArray_Size
#define StringSet_Comparator	StringArray_Comparator
#define Sentence_Comparator	StringArray_Comparator
#define StringSet_Write		StringArray_Write
#define Sentence_Write		StringArray_Write


#define StringArray_Empty(x) ( ((x) == NULL) \
			      || (STRINGARRAY_Size(x) <= 0) \
			      || (STRINGARRAY_Values(x) == NULL) )

#define StringSet_Empty(x) ( ((x) == NULL) \
			    || (STRINGSET_Size(x) <= 0) \
			    || (STRINGSET_Values(x) == NULL) )

#define Sentence_Empty(x) ( ((x) == NULL) \
			   || (SENTENCE_Size(x) <= 0) \
			   || (SENTENCE_Values(x) == NULL) )

/* message.c */
extern int PROGRAM_Verbose;
#define PROGRAM_TRACEVAL 50

extern void Message();
extern void Filtered_Message();

/* Error.c */

extern char        *__DepotErrorInfoFile;
extern unsigned int __DepotErrorInfoLineNo;
extern int PROGRAM_ErrorNo;

#define FatalError __DepotErrorInfoFile=__FILE__, \
                   __DepotErrorInfoLineNo=__LINE__, __FatalError

void __FatalError();

/* timer.c */
extern void timer_start();
extern void timer_status();
extern void timer_stop();

/* compress.c */
extern STRINGARRAY *compress_command();
extern STRINGARRAY *decompress_command();
#endif /* _DEPOT_UTIL_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/util/RCS/util.h,v $ */
