#ifdef LOG_TIME
/***********************************************************
        Copyright (c) 1993, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#if !defined(__CODECENTER__) || !defined(LINT)
static char rcs_id[] = "$Id: timer.c,v 1.4 1994/09/12 22:16:07 ww0r Exp $";
#endif

#include <sys/time.h>
#include <stdio.h>


void timer_start();
void timer_status();
void timer_stop();

static struct timeval *tv;

static FILE *outfp;

static struct timeval *
now()
{
  static struct timeval ntv;
  struct timezone tzp;

  if (gettimeofday(&ntv, &tzp) < 0) {
    perror("timer:gettimeofday in diff_time");
    exit(-1);
  }
  return &ntv;
}

static struct timeval *
diff_time(tv1,tv2)
  struct timeval *tv1, *tv2;
{
  static struct timeval ret;

  if (tv2->tv_usec > tv1->tv_usec) {
    tv1->tv_usec += 1000000;
    tv1->tv_sec--;
  }
  ret.tv_usec =  tv1->tv_usec - tv2->tv_usec;
  ret.tv_sec =  tv1->tv_sec - tv2->tv_sec;
  return (&ret);
}
  
  
void timer_start(fp) 
  FILE *fp;
{
  static struct timeval stv;
  
  outfp = (fp == NULL) ? stdout : fp;
  tv = now();
  stv.tv_usec = tv->tv_usec;
  stv.tv_sec = tv->tv_sec;
  tv = &stv;
}

void timer_status(msg) 
  char *msg;
{
  static struct timeval last = {0,0};
  struct timeval *ctv, *diff;

  if ((last.tv_usec == 0) && (last.tv_sec == 0)) {
    last.tv_usec = tv->tv_usec;
    last.tv_sec = tv->tv_sec;
  } 
  ctv = now();
  diff = diff_time(ctv,&last);

  fprintf(outfp,"%s: %d.%d\n",msg, diff->tv_sec,diff->tv_usec);
  ctv = now();
  last.tv_usec = ctv->tv_usec;
  last.tv_sec = ctv->tv_sec;
}

void timer_stop(msg)
  char *msg;
{
  struct timeval *ctv, *diff;

  ctv = now();
  timer_status("From last checkpoint");
  diff = diff_time(ctv, tv);
  fprintf(outfp,"%s: %d.%d\n",msg, diff->tv_sec,diff->tv_usec);
  tv = NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/012/src/lib/util/RCS/timer.c,v $ */
#endif /* LOG_TIME */
