/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: TargetDB_SetTargetMappings.c,v 1.6 1994/08/31 01:12:58 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"
#include "File.h"
#include "TargetDB.h"



static char *TARGETLISTVALUE_NULL[] =
{
  NULL
};

static STRINGARRAY TARGETLIST_NULL =
{
  0, TARGETLISTVALUE_NULL
};



static void TargetDB_NodeSetTargetMappings();
static void TargetDB_TreeSetTargetMappings();
static void TargetDB_SetTargetMappingPath();



static void TargetDB_NodeSetTargetMappings(nodep, mapmethod, filter)
     TARGETDB *nodep;
     unsigned mapmethod;
     SENTENCE *filter;
{
  /* erase previous mapping specifications other than noop or delete */
  TARGETDB_UpdateSpec(nodep) &= ~(U_MAP | U_MAPCOPY | U_MAPLINK | U_NONVIRGIN
				  | U_SPECIALPATH | U_SPECIAL
				  | U_NOOPPATH | U_NOOP
				  | U_COMMANDPATH | U_MKDIR | U_VIRGINLINK);
  TARGETDB_UpdateSpec(nodep) |= mapmethod;
  TARGETDB_Filter(nodep) = filter;
  return;
}



static void TargetDB_TreeSetTargetMappings(targetdbp, mapmethod, filter)
     TARGETDB *targetdbp;
     unsigned mapmethod;
     SENTENCE *filter;
{
  register int i;
  register TARGETDB **childp;

  TargetDB_NodeSetTargetMappings(targetdbp, mapmethod, filter);

  for (i = 0, childp = TARGETDB_Children(targetdbp);
       (PROGRAM_ErrorNo == E_NULL) && (i < TARGETDB_ChildCount(targetdbp));
       i++, childp++)
    {
      TargetDB_TreeSetTargetMappings(*childp, mapmethod, filter);
    }

  return;
}



static void TargetDB_SetTargetMappingPath(targetdbp, targetpath, mapmethod)
     TARGETDB *targetdbp;
     char *targetpath;
     unsigned mapmethod;
{
  register char **sp;

  TARGETDB *childnodep;
  STRINGARRAY *targetpathstringarray;
  char **targetpatharray;

  /* split target path into array of its components */
  targetpathstringarray = StringToStringArray(targetpath,
					'/' /* delimited by /s */,
					-1 /* no quotechar */);

  if (PROGRAM_ErrorNo == E_NULL)
    {
      if (targetpathstringarray == NULL)
	targetpatharray = NULL;
      else
	targetpatharray = STRINGARRAY_Values(targetpathstringarray);
    }

  /* go down the targetdatabase setting the approriate update spec. */
  if ((PROGRAM_ErrorNo == E_NULL) && (targetpatharray != NULL))
    {
      if (mapmethod & (U_NOOP|U_DELETE|U_MAPCOPY))
	{ TARGETDB_UpdateSpec(targetdbp) |= U_NONVIRGIN; }
      if (mapmethod & U_NOOP)
	{ TARGETDB_UpdateSpec(targetdbp) |= U_NOOPPATH; }
      for (sp = targetpatharray, childnodep = targetdbp;
	   (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL) && (childnodep != NULL);
	   sp++)
	{
	  if (*(sp+1) != NULL) /* all parent elements in the path */
	    {
	      childnodep = TargetDB_LocateChildNode(childnodep, *sp, TDB_LAX);
	      if ((PROGRAM_ErrorNo == E_NULL) && (childnodep != NULL))
		{
		  if (mapmethod & (U_NOOP|U_DELETE|U_MAPCOPY))
		    { TARGETDB_UpdateSpec(childnodep) |= U_NONVIRGIN; }
		  if (mapmethod & U_NOOP)
		    { TARGETDB_UpdateSpec(childnodep) |= U_NOOPPATH; }
		}
	    }
	}
    }
}



/*
 * Tie breaking precedence
 * noop > delete > copy > link > default
 */
TARGETDB *TargetDB_SetTargetMappings(targetdbp, preferencedbp)
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedbp;

{
  register char **copy, **delete, **link, **noop, **mapdefault, **filters;

  TARGETDB *newtargetdbp;

  STRINGSET *CopyList, *DeleteList, *LinkList, *NoopList, *DefaultList, *FilterList, *FilterNames;
  char **current;
  SENTENCE *filter;
  TARGETDBENTRY *targetdbnodep;
  Boolean EndOfLists;
  Boolean NoopTargetExists;
  Boolean DidCopyList;

  newtargetdbp = targetdbp;

  /* first reset all targetmappings specified in the tree to the default */
  if (newtargetdbp != NULL)
    { TargetDB_TreeSetTargetMappings(newtargetdbp, U_MAP, NULL); }

  /* Let's start by figuring out the filter names */
  FilterNames = Preference_GetStringSet(preferencedbp,
					PrefInternalCmdList,
					PrefInternalPref,
					&TARGETLIST_NULL, 
					0 /* don't allocate space */);
  filters = FilterNames ? STRINGSET_Values(FilterNames) : NULL;

  /* Now we can grab the lists for the default things... */
  CopyList = Preference_GetStringSet(preferencedbp,
				     "copy",
				     "target.installmethod",
				     &TARGETLIST_NULL,
				     0 /* don't allocate space */);
  DeleteList = Preference_GetStringSet(preferencedbp,
				       "delete",
				       "target.installmethod",
				       &TARGETLIST_NULL,
				       0 /* don't allocate space */);
  LinkList = Preference_GetStringSet(preferencedbp,
				     "link",
				     "target.installmethod",
				     &TARGETLIST_NULL,
				     0 /* don't allocate space */);
  NoopList = Preference_GetStringSet(preferencedbp,
				     "noop",
				     "target.installmethod",
				     &TARGETLIST_NULL,
				     0 /* don't allocate space */);
  DefaultList = Preference_GetStringSet(preferencedbp,
					"default",
					"target.installmethod",
					&TARGETLIST_NULL,
					0 /*don't allocate space */);

  copy = NULL;
  DidCopyList = FALSE;
  delete = STRINGSET_Values(DeleteList);
  link = STRINGSET_Values(LinkList);
  noop = STRINGSET_Values(NoopList);
  mapdefault = STRINGSET_Values(DefaultList);
  EndOfLists = FALSE;
  while ((PROGRAM_ErrorNo == E_NULL) && !EndOfLists) {
      while ((copy == NULL || *copy == NULL) && ! DidCopyList)
	  if (! (filters == NULL || *filters == NULL)) {
	      FilterList = Preference_GetStringSet(preferencedbp,
						   *filters,
						   "target.installmethod",
						   &TARGETLIST_NULL,
						   0 /* don't allocate space */);
	      copy = STRINGSET_Values(FilterList);
	      filter = Preference_GetSentence(preferencedbp,
					      *filters++,
					      "filter",
					      NULL);
	  } else {
	      copy = STRINGSET_Values(CopyList);
	      filter = NULL;
	      DidCopyList = TRUE;
	  }

      if (((copy == NULL) || (*copy == NULL))
	  && ((delete == NULL) || (*delete == NULL))
	  && ((link == NULL) || (*link == NULL))
	  && ((noop == NULL) || (*noop == NULL))
	  && ((mapdefault == NULL) || (*mapdefault == NULL)))
	{
	  EndOfLists = TRUE;
	}
      else
	{
	  current = noop;
	  if (((current == NULL) || (*current == NULL))
	      || ((delete != NULL) && (*delete != NULL)
		  && (String_Comparator(*current, *delete) >= 0)))
	    current = delete;
	  if (((current == NULL) || (*current == NULL))
	      || ((copy != NULL) && (*copy != NULL)
		  && (String_Comparator(*current, *copy) >= 0)))
	    current = copy;
	  if (((current == NULL) || (*current == NULL))
	      || ((link != NULL) && (*link != NULL)
		  && (String_Comparator(*current, *link) >= 0)))
	    current = link;
	  if (((current == NULL) || (*current == NULL))
	      || ((mapdefault != NULL) && (*mapdefault != NULL)
		  && (String_Comparator(*current, *mapdefault) >= 0)))
	    current = mapdefault;

	  targetdbnodep = TargetDB_LocateNode(newtargetdbp, *current, TDB_LAX);
	  if (current == noop)
	    {
	      if ((PROGRAM_ErrorNo == E_NULL) && (targetdbnodep == NULL))
		{
		  NoopTargetExists = TargetDB_CheckPathHierarchy(*current);
		  if ((PROGRAM_ErrorNo == E_NULL) && NoopTargetExists)
		    {
		      newtargetdbp = TargetDB_CreateTargetPath(newtargetdbp,
							       *current,
							       U_NOOP);
		      if (PROGRAM_ErrorNo == E_NULL)
			{
			  targetdbnodep = TargetDB_LocateNode(newtargetdbp,
							      *current,
							      TDB_LAX);
			}
		    }
		}
	      noop++;
	      if ((PROGRAM_ErrorNo == E_NULL) && (targetdbnodep != NULL))
		{
		  TargetDB_TreeSetTargetMappings(targetdbnodep, U_NOOP, NULL);
		  TargetDB_SetTargetMappingPath(newtargetdbp, *current, U_NOOP);
		}
	    }
	  else if (current == delete)
	    {
	      delete++;
	      if (targetdbnodep != NULL)
		{
		  TargetDB_TreeSetTargetMappings(targetdbnodep, U_DELETE, NULL);
		  TargetDB_SetTargetMappingPath(newtargetdbp, *current, U_DELETE);
		}
	    }
	  else if (current == copy)
	    {
	      copy++;
	      if (targetdbnodep != NULL)
		{
		  TargetDB_TreeSetTargetMappings(targetdbnodep,U_MAP|U_MAPCOPY, filter);
		  TargetDB_SetTargetMappingPath(newtargetdbp, *current, U_MAPCOPY);
		}
	    }
	  else if (current == link)
	    {
	      link++;
	      if (targetdbnodep != NULL)
		{
		  TargetDB_TreeSetTargetMappings(targetdbnodep,U_MAP|U_MAPLINK, NULL);
		  TargetDB_SetTargetMappingPath(newtargetdbp, *current, U_MAPLINK);
		}
	    }
	  else /* current == mapdefault */
	    {
	      mapdefault++;
	      if (targetdbnodep != NULL)
		{
		  TargetDB_TreeSetTargetMappings(targetdbnodep, U_MAP, NULL);
		  TargetDB_SetTargetMappingPath(newtargetdbp, *current, U_MAP);
		}
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/019/src/lib/TargetDB/RCS/TargetDB_SetTargetMappings.c,v $ */
