/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_Obsolete.c,v 1.4 1994/10/03 21:34:19 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"


static void TargetDB_TreeObsoleteCollection();
static Boolean TargetDB_TreeUnObsoleteCollection();


static void 
TargetDB_TreeObsoleteCollection(targetdbp, collectionid)
     TARGETDB *targetdbp;
     int collectionid;
{
  register int i;
  register TARGETDB **childp;

  int collectionindex;
  TARGETSOURCELIST *sourcelistp;
  TARGETSOURCE *sourcep;
  Boolean FoundCollection, FoundDirectory, PastCollection;

  if ((targetdbp != NULL) && (TARGETDB_SourceList(targetdbp) != NULL)) {
    sourcelistp = TARGETDB_SourceList(targetdbp);
    collectionindex =
      SourceList_FindIndexToCollectionId(sourcelistp, collectionid, TDB_LAX);
    if (collectionindex >= 0) {
      FoundCollection = TRUE;
    } else {
      FoundCollection = FALSE;
    }

    if ((PROGRAM_ErrorNo == E_NULL) && FoundCollection) {
      FoundDirectory = FALSE;
      PastCollection = FALSE;
      i = collectionindex;
      while ((PROGRAM_ErrorNo == E_NULL)
	     && !PastCollection
	     && (i < TARGETSOURCELIST_NSources(sourcelistp))) {
	sourcep = TARGETSOURCELIST_Source(sourcelistp, i);
	if (TARGETSOURCE_CollectionId(sourcep) == collectionid) {
	  if (TARGETSOURCE_UpdateSpec(sourcep) & U_MKDIR) {
	    FoundDirectory = TRUE;
	  }
	  while (sourcep != NULL) {
	    TARGETSOURCE_Status(sourcep) |= S_OBSOLETE;
	    sourcep = TARGETSOURCE_SecondarySource(sourcep);
	  }
	} else {
	  PastCollection = TRUE;
	}
	i++;
      }

      if ((PROGRAM_ErrorNo == E_NULL) && FoundDirectory) {
	for (i = 0, childp = TARGETDB_Children(targetdbp);
	     (PROGRAM_ErrorNo == E_NULL)
	     && (i < TARGETDB_ChildCount(targetdbp));
	     i++, childp++) {
	  TargetDB_TreeObsoleteCollection(*childp, collectionid);
	}
      }
    }
  }
  return;
}


static Boolean 
TargetDB_TreeUnObsoleteCollection(targetdbp,
				  collectionid,
				  newinstallmethod)
     TARGETDB *targetdbp;
     int collectionid;
     unsigned newinstallmethod;
{
  register int i;
  register TARGETDB **childp;

  int collectionindex;
  TARGETSOURCELIST *sourcelistp;
  TARGETSOURCE *sourcep;
  Boolean FoundCollection, FoundDirectory, PastCollection;

  Boolean ModifiedNode, ModifiedChildren;

  ModifiedNode = FALSE;
  if ((targetdbp != NULL) && (TARGETDB_SourceList(targetdbp) != NULL)) {
    sourcelistp = TARGETDB_SourceList(targetdbp);
    collectionindex =
      SourceList_FindIndexToCollectionId(sourcelistp, collectionid, TDB_LAX);
    if (collectionindex >= 0) {
      FoundCollection = TRUE;
    } else {
      FoundCollection = FALSE;
    }

    if ((PROGRAM_ErrorNo == E_NULL) && FoundCollection) {
      FoundDirectory = FALSE;
      PastCollection = FALSE;
      i = collectionindex;
      while ((PROGRAM_ErrorNo == E_NULL)
	     && !PastCollection
	     && (i < TARGETSOURCELIST_NSources(sourcelistp))) {
	sourcep = TARGETSOURCELIST_Source(sourcelistp, i);
	if (TARGETSOURCE_CollectionId(sourcep) == collectionid) {
	  if (TARGETSOURCE_UpdateSpec(sourcep) & U_MKDIR) {
	    FoundDirectory = TRUE;
	  }
	  while (sourcep != NULL) {
	    TARGETSOURCE_Status(sourcep) |= S_UNOBSOLETEDSUBTREE;
	    TARGETSOURCE_Status(sourcep) &= ~S_OBSOLETE;
	    if ((TARGETSOURCE_OldUpdateSpec(sourcep)
		 & (U_MAPLINK | U_MAPCOPY)) != newinstallmethod) {
	      TARGETSOURCE_UpdateSpec(sourcep)
		&= ~(U_MAPLINK | U_MAPCOPY);
	      TARGETSOURCE_UpdateSpec(sourcep)
		|= (newinstallmethod & (U_MAPLINK | U_MAPCOPY));
	      TARGETDB_Status(sourcep) |= S_MODIFIED;
	      TARGETDB_Status(targetdbp) |= S_MODIFIED;
	      ModifiedNode = TRUE;
	    }
	    sourcep = TARGETSOURCE_SecondarySource(sourcep);
	  }
	} else {
	  PastCollection = TRUE;
	}
	i++;
      }

      ModifiedChildren = FALSE;
      /* recursively unobsolete collection in children */
      if ((PROGRAM_ErrorNo == E_NULL) && FoundDirectory) {
	for (i = 0, childp = TARGETDB_Children(targetdbp);
	     (PROGRAM_ErrorNo == E_NULL)
	     && (i < TARGETDB_ChildCount(targetdbp));
	     i++, childp++) {
	  ModifiedChildren |=
	    TargetDB_TreeUnObsoleteCollection(*childp,
					      collectionid,
					      newinstallmethod);
	}
      }
      if ((PROGRAM_ErrorNo == E_NULL) && ModifiedChildren) {
	TARGETDB_Status(targetdbp) |= S_MODIFIEDCHILDREN;
	ModifiedNode = TRUE;
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? ModifiedNode : FALSE;
}



TARGETDB *
TargetDB_ObsoleteCollection(targetdbp, collectionid)
     TARGETDB *targetdbp;
     int collectionid;
{
  TargetDB_TreeObsoleteCollection(targetdbp, collectionid);

  return (PROGRAM_ErrorNo == E_NULL) ? targetdbp : NULL;
}


TARGETDB *
TargetDB_UnObsoleteCollection(targetdbp,
			      collectionid,
			      newinstallmethod)
     TARGETDB *targetdbp;
     int collectionid;
     unsigned newinstallmethod;
{
  (void) TargetDB_TreeUnObsoleteCollection(targetdbp,
					   collectionid,
					   newinstallmethod);

  return (PROGRAM_ErrorNo == E_NULL) ? targetdbp : NULL;
}



Boolean 
TargetDB_UnObsoleteSource(targetdbp,
			  sourcepath,
			  collectionid,
			  newinstallmethod)
     TARGETDB *targetdbp;
     char *sourcepath;
     int collectionid;
     unsigned newinstallmethod;
{
  register int i;
  register TARGETDB **childp;

  Boolean ModifiedNode, ModifiedChildren;

  char newsourcepath[MAXPATHLEN + 1];
  int sourceindex;
  TARGETSOURCE *sourcep;

  ModifiedNode = FALSE;
  if (sourcepath == NULL) {
    FatalError(E_BADTARGETSOURCEPATH,
	     "Attempt to unobsolete NULL sourcepath in target database.\n");
  }
  if ((PROGRAM_ErrorNo == E_NULL) && (targetdbp != NULL)) {
    sourceindex = SourceList_FindIndexToSource(TARGETDB_SourceList(targetdbp),
					       sourcepath,
					       collectionid,
					       TDB_LAX);
    if ((PROGRAM_ErrorNo == E_NULL) && (sourceindex >= 0)) {
      sourcep = TARGETSOURCELIST_Source(TARGETDB_SourceList(targetdbp),
					sourceindex);
      while (sourcep != NULL) {
	if (TARGETSOURCE_Status(sourcep) & S_OBSOLETE) {
	  TARGETSOURCE_Status(sourcep) |= S_UNOBSOLETEDSUBTREE;
	  TARGETSOURCE_Status(sourcep) &= ~S_OBSOLETE;
	  if ((TARGETSOURCE_OldUpdateSpec(sourcep)
	       & (U_MAPLINK | U_MAPCOPY)) != newinstallmethod) {
	    TARGETSOURCE_UpdateSpec(sourcep) &= ~(U_MAPLINK | U_MAPCOPY);
	    TARGETSOURCE_UpdateSpec(sourcep) |= (newinstallmethod &
						 (U_MAPLINK | U_MAPCOPY));
	    TARGETDB_Status(sourcep) |= S_MODIFIED;
	    TARGETDB_Status(targetdbp) |= S_MODIFIED;
	    ModifiedNode = TRUE;
	  }
	}
	sourcep = TARGETSOURCE_SecondarySource(sourcep);
      }

      ModifiedChildren = FALSE;
      /* recursively unobsolete sources in children */
      for (i = 0, childp = TARGETDB_Children(targetdbp);
	   (PROGRAM_ErrorNo == E_NULL)
	   && (i < TARGETDB_ChildCount(targetdbp));
	   i++, childp++) {
	if (strcmp(sourcepath, "/") == 0)
	  (void) strcpy(newsourcepath, TARGETDB_Name(*childp));
	else
	  (void) sprintf(newsourcepath, "%s/%s",
			 sourcepath, TARGETDB_Name(*childp));
	ModifiedChildren |= TargetDB_UnObsoleteSource(*childp,
						      newsourcepath,
						      collectionid,
						      newinstallmethod);
      }

      if ((PROGRAM_ErrorNo == E_NULL) && ModifiedChildren) {
	TARGETDB_Status(targetdbp) |= S_MODIFIEDCHILDREN;
	ModifiedNode = TRUE;
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? ModifiedNode : FALSE;
}

/* $Source: /afs/andrew/system/src/local/depot2/013/src/lib/TargetDB/RCS/TargetDB_Obsolete.c,v $ */
