/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_Command.c,v 1.5 1994/08/19 20:51:15 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Preference.h"
#include "TargetDB.h"



Boolean 
TargetDB_CommandTargetExists(label, targetdbp, preferencedbp)
     char *label;
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedbp;
{
  register char **tp;

  Boolean TargetExists;

  char **TargetList;
  STRINGSET *TargetListSet;
  TARGETDBENTRY *targetnodep;

  TargetExists = FALSE;
  TargetListSet = Preference_GetStringSet(preferencedbp,
					  label, "target.command", NULL, 
					  0 /* don't allocate space */);
  if (PROGRAM_ErrorNo == E_NULL) {
    if (TargetListSet == NULL) {
      TargetList = NULL;
    } else {
      TargetList = STRINGSET_Values(TargetListSet);
    }
  }
  if ((PROGRAM_ErrorNo == E_NULL) && (TargetList != NULL)) {
    tp = TargetList;
    while ((PROGRAM_ErrorNo == E_NULL) && !TargetExists && (*tp != NULL)) {
      targetnodep = TargetDB_LocateNode(targetdbp, *tp, TDB_LAX);
      if ((PROGRAM_ErrorNo == E_NULL) && (targetnodep != NULL)) {
	TargetExists = TRUE;
      }
      tp++;
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? TargetExists : FALSE;
}



Boolean 
TargetDB_CommandTargetModified(label, targetdbp, preferencedbp)
     char *label;
     TARGETDB *targetdbp;
     PREFERENCEDB *preferencedbp;
{
  register char **tp;

  Boolean TargetModified;

  char **TargetList;
  STRINGSET *TargetListSet;
  TARGETDBENTRY *targetnodep;

  TargetModified = FALSE;
  TargetListSet = Preference_GetStringSet(preferencedbp,
					  label, "target.command", NULL,
					  0 /* don't allocate space */);
  if (PROGRAM_ErrorNo == E_NULL) {
    if (TargetListSet == NULL) {
      TargetList = NULL;
    } else {
      TargetList = STRINGSET_Values(TargetListSet);
    }
  }
  if ((PROGRAM_ErrorNo == E_NULL) && (TargetList != NULL)) {
    tp = TargetList;
    while ((PROGRAM_ErrorNo == E_NULL) && !TargetModified && (*tp != NULL)) {
      targetnodep = TargetDB_LocateNode(targetdbp, *tp, TDB_LAX);
      if ((PROGRAM_ErrorNo == E_NULL)
	  && (targetnodep != NULL)
	  && (TARGETDB_Status(targetnodep) & (S_MODIFIED | S_MODIFIEDCHILDREN))) {
	TargetModified = TRUE;
      }
      tp++;
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? TargetModified : FALSE;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/TargetDB/RCS/TargetDB_Command.c,v $ */


