/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: SourceList_Conflict.c,v 1.5 1994/08/12 22:17:17 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Hint.h"
#include "File.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"
#include "Preference.h"


static Boolean TargetSource_CheckConsistency();



static Boolean 
TargetSource_CheckConsistency(sourcep1, sourcep2,
			      preferencedb,
			      collectionlistp,
			      findallconflicts)
     TARGETSOURCE *sourcep1, *sourcep2;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
     Boolean findallconflicts;
{
  int collectionid1, collectionid2;
  char *collectionname1, *collectionname2;
  Boolean OverridingCollectionPair;
  Boolean ConsistentSources;

  ConsistentSources = TRUE;

  /* 
   * $$$OPTIMIZATION$$$
   * Move the override checking code to blocks handling specific update types
   */
  collectionid1 = TARGETSOURCE_CollectionId(sourcep1);
  collectionid2 = TARGETSOURCE_CollectionId(sourcep2);
  if (collectionid1 == collectionid2) {
    OverridingCollectionPair = FALSE;
  } else {
    collectionname1 =
      COLLECTION_Name(COLLECTIONLIST_Collection(collectionlistp,
						collectionid1));
    collectionname2 =
      COLLECTION_Name(COLLECTIONLIST_Collection(collectionlistp,
						collectionid2));

    OverridingCollectionPair = PreferenceDB_Override(collectionname2,
						     collectionname1,
						     preferencedb);
  }

  if (!(TARGETSOURCE_UpdateSpec(sourcep1)
	& (U_MAP | U_MKDIR | U_HARDLINK | U_COMMAND))) {
    FatalError(E_BADSOURCEUPDTSPEC,
	       "Bad update specification %x for source at node %s.\n",
	       TARGETSOURCE_UpdateSpec(sourcep1),
	       TARGETSOURCE_Path(sourcep1));
  } else if (!(TARGETSOURCE_UpdateSpec(sourcep2)
	       & (U_MAP | U_MKDIR | U_HARDLINK | U_COMMAND))) {
    FatalError(E_BADSOURCEUPDTSPEC,
	       "Bad update specification %x for source at node %s.\n",
	       TARGETSOURCE_UpdateSpec(sourcep2),
	       TARGETSOURCE_Path(sourcep2));
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (TARGETSOURCE_UpdateSpec(sourcep1) & (U_MAP | U_HARDLINK)) {
      if (!OverridingCollectionPair && 
	  ((collectionid1 != collectionid2) || 
	   !(TARGETSOURCE_UpdateSpec(sourcep2) & U_COMMAND))) {
	ConsistentSources = FALSE;
      }
    } else if (TARGETSOURCE_UpdateSpec(sourcep1) & U_MKDIR) {
      if (!(TARGETSOURCE_UpdateSpec(sourcep2) & U_MKDIR)) {
#if 0
	/* since I want to allow overrides for both
	 * these checks aren\'t necessary... or so I think....
	 */
	if ((TARGETSOURCE_UpdateSpec(sourcep2) & U_COMMAND) && 
	    !(TARGETSOURCE_UpdateSpec(sourcep1) & U_COMMANDPATH)) {
	  if (!OverridingCollectionPair) {
	    ConsistentSources = FALSE;
	  }
	} else {
	  ConsistentSources = FALSE;
	}
#endif
	if (!OverridingCollectionPair) {
	  ConsistentSources = FALSE;
	}
      }
    } else {         /* (TARGETSOURCE_UpdateSpec(sourcep1) & U_COMMAND) */
      if ((collectionid1 == collectionid2) ||
	  !(TARGETSOURCE_UpdateSpec(sourcep2) & U_COMMAND) ||
	  (String_Comparator(TARGETSOURCE_Path(sourcep1),
			     TARGETSOURCE_Path(sourcep2)) != 0)) {
	ConsistentSources = FALSE;
/* XXXX I am not changing this to allow for overrides as I\'m not
 *      completely sure what this is checking for...
 */
      }
    }
    if (!ConsistentSources) {
      TargetDB_ReportFileConflict(sourcep1, sourcep2, 
			      COLLECTIONLIST_Collection(collectionlistp, 
							collectionid1), 
			      COLLECTIONLIST_Collection(collectionlistp, 
							collectionid2), 
			      findallconflicts);
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? ConsistentSources : FALSE;
}


Boolean 
SourceList_CheckConsistency(sourcelistp,
			    preferencedb,
			    collectionlistp,
			    findallconflicts)
     TARGETSOURCELIST *sourcelistp;
     PREFERENCEDB *preferencedb;
     COLLECTIONLIST *collectionlistp;
     Boolean findallconflicts;
{
  register unsigned int i1, i2;
  register TARGETSOURCE *sp1, *sp2;

  Boolean NoConflictFound;

  NoConflictFound = TRUE;
  for (i1 = 0;
       (PROGRAM_ErrorNo == E_NULL)
       && (NoConflictFound || findallconflicts)
       && (i1 < TARGETSOURCELIST_NSources(sourcelistp));
       i1++) {
    sp1 = TARGETSOURCELIST_Source(sourcelistp, i1);
    for (i2 = i1 + 1;
	 (PROGRAM_ErrorNo == E_NULL)
	 && (NoConflictFound || findallconflicts)
	 && (i2 < TARGETSOURCELIST_NSources(sourcelistp));
	 i2++) {
      sp2 = TARGETSOURCELIST_Source(sourcelistp, i2);
      NoConflictFound &= TargetSource_CheckConsistency(sp1, sp2,
						       preferencedb,
						       collectionlistp,
						       findallconflicts);
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? NoConflictFound : FALSE;
}

/* $Source: /afs/andrew/system/src/local/depot2/013/src/lib/TargetDB/RCS/SourceList_Conflict.c,v $ */
