/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: HintService_GetRelatedHints.c,v 1.6 1994/09/09 03:05:01 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"
#include "HintService.h"


static HINTDB HintService_ReadRelatedHintsFromLocation();

/*
 * CAVEAT : This is only a temporary function to get hint functionality working
 */
HINTDB
HintService_GetRelatedHints(pathprefix, hintlocation)
     char *pathprefix;
     char *hintlocation;
{
  HINTDB hintdb;

  hintdb = HintService_ReadRelatedHintsFromLocation(hintlocation, pathprefix);

  return (PROGRAM_ErrorNo == E_NULL) ? hintdb : NULL;
}


static HINTDB
HintService_ReadRelatedHintsFromLocation(hintlocation, pathprefix)
     char *pathprefix;
     char *hintlocation;
{
  FILE *hintfd;
  HINTDB hintdb;
  HINT hint;
  char hintpath[MAXPATHLEN], hintid[MAXPATHLEN], tmpstr[MAXPATHLEN];
  FILESTAT hintlocationstatus;

  Boolean before, during;
  int Comparison;

  hintdb = NULL;

  (void) File_GetStatus(hintlocation, &hintlocationstatus, FALSE /* followlinks */ );
  if ((PROGRAM_ErrorNo == E_NULL) && (FILESTAT_Type(&hintlocationstatus) & F_REG)) {
    hintfd = efopen(hintlocation, "r");
    if (PROGRAM_ErrorNo == E_NULL) {
      before = TRUE;
      during = FALSE;
      while (before && (PROGRAM_ErrorNo == E_NULL)) {
	if (fgets(hintpath, MAXPATHLEN, hintfd) == NULL) {
	  /* eof or error */
	  before = during = FALSE;
	} else if (strncmp(hintpath, "PATH ", 5) != 0) {
	  before = during = FALSE;
	  FatalError(E_BADHINTS,
		     "Corrupted hints in location %s\n", hintlocation);
	} else {
	  Comparison = strncmp(hintpath + 5, pathprefix, strlen(pathprefix));
	  if (Comparison == 0) {
	    before = FALSE;
	    during = TRUE;
	  } else if (Comparison > 0) {
	    before = during = FALSE;
	  } else {		/* Comparison < 0 */
	    if ((fgets(hintid, MAXPATHLEN, hintfd) == NULL)
		|| (fgets(tmpstr, MAXPATHLEN, hintfd) == NULL)) {
	      before = during = FALSE;
	      FatalError(E_BADHINTS,
			 "Unexpected end to hints in location %s\n",
			 hintlocation);
	    } else if ((strncmp(hintid, "ID ", 3) != 0)
		       || (strncmp(tmpstr, "MODTIME ", 8) != 0)) {
	      before = during = FALSE;
	      FatalError(E_BADHINTS,
			 "Corrupted hints in location %s\n",
			 hintlocation);
	    }
	  }
	}
      }

      while (during && (PROGRAM_ErrorNo == E_NULL)) {
	if ((fgets(hintid, MAXPATHLEN, hintfd) == NULL)
	    || (fgets(tmpstr, MAXPATHLEN, hintfd) == NULL)) {
	  before = during = FALSE;
	  FatalError(E_BADHINTS,
		     "Unexpected end to hints in location %s\n",
		     hintlocation);
	} else if ((strncmp(hintid, "ID ", 3) != 0)
		   || (strncmp(tmpstr, "MODTIME ", 8) != 0)) {
	  before = during = FALSE;
	  FatalError(E_BADHINTS,
		     "Corrupted hints in location %s\n", hintlocation);
	} else {
	  /* 
	   * NOTE: The assignments to hint's components could have been
	   * done outside the loop, but it is clearer if we put it here
	   */
	  if (hintpath[strlen(hintpath) - 1] == '\n')
	    hintpath[strlen(hintpath) - 1] = '\0';
	  if (hintid[strlen(hintid) - 1] == '\n')
	    hintid[strlen(hintid) - 1] = '\0';
	  if (tmpstr[strlen(tmpstr) - 1] == '\n')
	    tmpstr[strlen(tmpstr) - 1] = '\0';
	  HINT_PathName(&hint) = hintpath + 5;	/* offset "PATH " */
	  HINT_UniqueID(&hint) = hintid + 3;	/* offset "ID " */
	  HINT_ModTime(&hint) = (time_t) atoi(tmpstr + 8);
	  /* number at offset "MODTIME " */
	  hintdb = HintDB_InsertHint(hintdb, &hint, TRUE /* OverWrite */ );
	}

	if (PROGRAM_ErrorNo == E_NULL) {
	  if (fgets(hintpath, MAXPATHLEN, hintfd) == NULL)
	    /* eof or error */
	  {
	    before = during = FALSE;
	  } else if (strncmp(hintpath, "PATH ", 5) != 0) {
	    before = during = FALSE;
	    FatalError(E_BADHINTS,
		       "Corrupted hints in location %s\n", hintlocation);
	  } else {
	    Comparison = strncmp(hintpath + 5, pathprefix, strlen(pathprefix));
	    if (Comparison == 0) {
	      before = FALSE;
	      during = TRUE;
	    } else if (Comparison > 0) {
	      before = during = FALSE;
	    } else {		/* Comparison < 0 shouldn't happen */
	      before = during = FALSE;
	      FatalError(E_BADHINTS,
			 "Unsorted hints in location %s\n",
			 hintlocation);
	    }
	  }
	}
      }
      fclose(hintfd);
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? hintdb : NULL;
}

/* $Source: /afs/andrew/system/src/local/depot2/012/src/lib/HintService/RCS/HintService_GetRelatedHints.c,v $ */
