/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: HintDB_InsertHint.c,v 1.6 1995/05/11 17:40:48 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"

/*
 * HINTDB HintDB_InsertHint(hintdb, hintp, OverWrite)
 *      HINTDB hintdb, *hintp;
 Boolean OverWrite;
 * inserts the hint information pointed to by hintp into
 * the NULL terminated array of hints, sorted by the pathname field.
 * The OverWrite flag determines whether already existing hints are overwritten.
 * It then returns the updated array of hints, or NULL if an error occurs.
 */
HINTDB 
HintDB_InsertHint(hintdb, hintp, OverWrite)
     HINTDB hintdb;
     HINT *hintp;
     Boolean OverWrite;
{
  HINTDB newdb;

  register HINTDB hp, tp;
  register unsigned int i;
  unsigned int InsertPoint, ArraySize;
  int HintComparison;
  Boolean DuplicateHint, LocatedInsertPoint;

  if (hintp == NULL) {
    FatalError(E_NULLHINT,
	       "Attempt to insert NULL hint into array of hints.\n");
  } else {
    newdb = hintdb;
    if (newdb == NULL) {	/* allocate array of length 1 */
      newdb = (HINTDB) emalloc(sizeof(HINT *));
      if (PROGRAM_ErrorNo == E_NULL)
	*newdb = NULL;
    }
    if (PROGRAM_ErrorNo == E_NULL) {
      i = 0;
      hp = newdb;
      DuplicateHint = FALSE;
      LocatedInsertPoint = FALSE;
      while (!LocatedInsertPoint && !DuplicateHint && (*hp != NULL)) {
	HintComparison = strcmp(HINT_PathName(*hp),
				HINT_PathName(hintp));
	if (HintComparison == 0) {
	  DuplicateHint = TRUE;
	  LocatedInsertPoint = TRUE;
	  InsertPoint = i;
	} else if (HintComparison > 0) {
	  LocatedInsertPoint = TRUE;
	  InsertPoint = i;
	} else {		/* HintComparison < 0 */
	  i++;
	  hp++;
	}
      }

      if (!DuplicateHint && (HINT_UniqueID(hintp) == NULL))
	/* EMPTY */
	/* do nothing */ ;
      else if (!DuplicateHint && (HINT_UniqueID(hintp) != NULL)) {
	ArraySize = HintDB_Size(newdb) + 1;
	if (!LocatedInsertPoint)
	  InsertPoint = ArraySize - 1;
	ArraySize++;
	newdb = (HINTDB) erealloc((char *) newdb,
				  ArraySize * sizeof(HINT *));
	if (newdb != NULL) {
	  i = ArraySize - 1;
	  hp = newdb + i - 1;
	  tp = newdb + i;
	  while (i > InsertPoint) {
	    *tp-- = *hp--;
	    i--;
	  }
	  hp = newdb + InsertPoint;
	  *hp = (HINT *) emalloc(sizeof(HINT));
	  if (*hp != NULL) {
	    HINT_PathName(*hp) = String(HINT_PathName(hintp),
					strlen(HINT_PathName(hintp)));
	    HINT_UniqueID(*hp) = String(HINT_UniqueID(hintp),
					strlen(HINT_UniqueID(hintp)));
	    HINT_ModTime(*hp) = HINT_ModTime(hintp);
	  }
	}
      } else if (DuplicateHint && (HINT_UniqueID(hintp) == NULL)) {
	/* InsertPoint here is actually a DeletionPoint */
	/* remove the entry with the NULL hint */
	ArraySize = HintDB_Size(newdb) + 1;  
	if (!LocatedInsertPoint)
	  InsertPoint = (unsigned int) ArraySize - 1;

	i = InsertPoint +1;
	tp = newdb + InsertPoint; 
	hp = newdb + i;
	while (i < ArraySize) {
	  *tp++ = *hp++;
	  i++;
	}
	/* cut array down to size */
	ArraySize--; 
	newdb = (HINTDB) erealloc((char *) newdb,
				  (unsigned) ArraySize * sizeof(HINT *));
      } else if (OverWrite)
	/* DuplicateHint && (HINT_UniqueID(hintp) != NULL) */
      {
	hp = newdb + InsertPoint;
	if (HINT_PathName(*hp) != NULL)
	  free(HINT_PathName(*hp));
	if (HINT_UniqueID(*hp) != NULL)
	  free(HINT_UniqueID(*hp));
	  
	HINT_PathName(*hp) = String(HINT_PathName(hintp),
				    strlen(HINT_PathName(hintp)));
	HINT_UniqueID(*hp) = String(HINT_UniqueID(hintp),
				    strlen(HINT_UniqueID(hintp)));
	HINT_ModTime(*hp) = HINT_ModTime(hintp);
      }
    }
  }

  return (PROGRAM_ErrorNo == E_NULL) ? newdb : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/src/lib/Hint/RCS/HintDB_InsertHint.c,v $ */
