/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: CollectionList_Read.c,v 1.6 1994/10/13 15:18:29 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "Hint.h"
#include "FileSystemImage.h"
#include "DepotConf.h"
#include "TargetDB.h"
#include "Collection.h"
#include "CollectionList.h"


COLLECTIONLIST *
CollectionList_Read(fp)
     FILE *fp;
{
  register unsigned int i;
  register COLLECTION *cp;
  unsigned int clistsize, ncollections;
  int commandlistsize;
  COLLECTIONLIST *clistp;
  unsigned int id;

  clistsize = efgetunsigned(fp);
  ncollections = efgetunsigned(fp);
  clistp = (COLLECTIONLIST *) emalloc(sizeof(COLLECTIONLIST));
  if (PROGRAM_ErrorNo == E_NULL) {
    COLLECTIONLIST_Size(clistp) = clistsize;
    COLLECTIONLIST_CollectionArray(clistp)
      = (COLLECTION **) ecalloc(clistsize + 1, sizeof(COLLECTION *));
  }
  i = 0;
  while ((i < ncollections) && (PROGRAM_ErrorNo == E_NULL)) {
    id = efgetunsigned(fp);
    if (id >= clistsize) {
      FatalError(E_BADCOLLECTIONID,
		 "Invalid collection id %d in collection list file.\n",
		 id);
    }
    if (PROGRAM_ErrorNo == E_NULL) {
      cp = (COLLECTION *) emalloc(sizeof(COLLECTION));
      (void)memset(cp, 0, sizeof(COLLECTION));
    }
    if (PROGRAM_ErrorNo == E_NULL)
      COLLECTION_Name(cp) = efgetstring(fp, '\\' /* quotechar */ );
    if (PROGRAM_ErrorNo == E_NULL)
      COLLECTION_Path(cp) = efgetstring(fp, '\\' /* quotechar */ );
    if (PROGRAM_ErrorNo == E_NULL) {
      COLLECTION_CommandList(cp) = NULL;
      commandlistsize = efgetint(fp);
      while ((commandlistsize > 0) && (PROGRAM_ErrorNo == E_NULL)) {
	char *command;

	command = efgetstring(fp, '\\' /* quotechar */ );
	COLLECTION_CommandList(cp)
	  = StringSet_AddString(COLLECTION_CommandList(cp), command);
	commandlistsize--;
	free(command);
      }
    }
    if (PROGRAM_ErrorNo == E_NULL) {
      COLLECTION_DepotConfDB(cp) =
	CollectionDepotConfDB_Read(fp, COLLECTION_Name(cp));
    }
    if (PROGRAM_ErrorNo == E_NULL)
      COLLECTION_HintDB(cp) = HintDB_Read(fp);
    if (PROGRAM_ErrorNo == E_NULL) {
      COLLECTION_Id(cp) = id;
      COLLECTION_Image(cp) = NULL;
      COLLECTION_TargetDB(cp) = NULL;
      COLLECTION_Status(cp) = 0;
      COLLECTIONLIST_Collection(clistp, id) = cp;
    }
    i++;
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    COLLECTIONLIST_Collection(clistp, clistsize) = NULL;
  }
  return (PROGRAM_ErrorNo == E_NULL) ? clistp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/CollectionList/RCS/CollectionList_Read.c,v $ */
