/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef _DEPOT_COLLECTION_H
#define _DEPOT_COLLECTION_H

/* $Id: Collection.h,v 1.3 1994/08/12 03:16:53 ww0r Exp $
 * 
 * Author: Sohan C. Ramakrishna Pillai
 */


typedef struct Collection
{
  unsigned int id;
  char *name;
  char *path;
  unsigned int mapmethod;
  HINTDB hintdb;
  FILESYSTEMIMAGE *image;
  DEPOTCONFDB *depotconfdb;
  STRINGSET *commandlist;
  TARGETDB *targetdb;
  unsigned int status;
} COLLECTION;


#define COLLECTION_Id(cp)		((cp)->id)
#define COLLECTION_Name(cp)		((cp)->name)
#define COLLECTION_Path(cp)		((cp)->path)
#define COLLECTION_MapMethod(cp)	((cp)->mapmethod)
#define COLLECTION_HintDB(cp)		((cp)->hintdb)
#define COLLECTION_Image(cp)		((cp)->image)
#define COLLECTION_DepotConfDB(cp)	((cp)->depotconfdb)
#define COLLECTION_CommandList(cp)	((cp)->commandlist)
#define COLLECTION_TargetDB(cp)		((cp)->targetdb)
#define COLLECTION_Status(cp)		((cp)->status)

#define C_DELETE		0x0001
#define C_IGNORE		0x0002
#define C_POSSIBLYNONEXISTENT	0x0004
#define C_NONEXISTENT		0x0008
#define C_HINTSUNAVAILABLE	0x0010
#define C_MODTIMECHANGE		0x0020
#define C_PREFERENCECHANGE	0x0040
#define C_INSTALLMETHODCHANGE	0x0080
#define C_OVERRIDECHANGE	0x0100
#define C_PATHCHANGE		0x0200
#define C_DEPOTCONFCHANGE	0x0400
#define C_NEW			0x0800
#define C_UPDATE		0x1000


extern char *Collection_LocatePath();

extern TARGETDB *Collection_TargetDBGenerate();
extern TARGETDB *Collection_FSImageMap();
extern TARGETSOURCE *Collection_TargetSourceFromFSImage();
extern TARGETDB *Collection_PathMap();
extern TARGETSOURCE *Collection_TargetSourceFromFileStatus();
extern TARGETDB *Collection_DeleteTarget();
extern TARGETDB *Collection_CommandTarget();

extern TARGETDB *Collection_TargetDBCreateNonVirginPath();
extern TARGETDB *Collection_TargetDBCreateCommandPath();
extern TARGETSOURCELIST *Collection_SourceList_AddSource();

extern void Collection_Free();

#endif /* _DEPOT_COLLECTION_H */
