.\"
.\" $Id: hintservice.man,v 2.0 1994/12/14 15:10:06 ww0r Exp $
.\" $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/man/man1/RCS/hintservice.man,v $
.\"
.\"        Copyright 1994 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH HINTSERVICE 1
.SH NAME
\fBhintservice\fP  \- sets up hints for depot
.SH SYNOPSIS
.B hintservice 
-set location -image imagefilename hintprefix
.br
.B hintservice 
-set location -file filename hintprefix
.br
.B hintservice 
-unset location hintprefix
.br
.B hintservice 
-get location path
.br
.B hintservice 
-getall location subtreepath
.br
.SH DESCRIPTION
\fBhintservice\fP provides an \fBoptional\fP method to decrease the time it
takes for \fBdepot\fP to run. This is done by storing the path to a
collection and the last update time in a hintfile. The hintfile is
then used by \fBdepot\fP to obtain this information, instead of by
other means.
.SH USAGE
In general, \fBhintservice\fP is used in conjunction with the
\fIdepot.image\fP file created by \fBfsi_generate\fP.
.PP
To add a hint, in the \fIdepot\fP subdirectory, run the following
command:
.PP
	hintservice -set depot.hint -image gnudiff.763832317/depot.image
.br
		gnudiff.763832317 
.PP
To remove a hint,in the \fB depot\fP subdirectory, run the following command:
.PP
	hintservice -unset depot.hint gnudiff.763832317 
.PP
.SH BUGS
The hints specified must be valid. A bad hint will result in weird
errors.
.SH FILES
.TP 0
.B \[targetdir\]/depot/depot.hint
	This is the default location for the hintfile.
.SH "SEE ALSO"
depot(1), fsi_generate(1)
.SH AUTHOR
Sohan C. Ramakrishna-Pillai





