/*
	daapd 0.2.4, a server for the DAA protocol
	(c) deleet 2003, Alexander Oberdoerster

	utility functions
	

	daapd is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	daapd is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with daapd; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "util.h"
#include "types.h"

#include <iostream>
#include <string>
#include <vector>

#include <sys/param.h>
#include <cstdlib>

using namespace std;
     
ComponentVect *tokenizeString( ComponentVect& components, const char* s_, const char delim ) {
	string s( s_ );
	string::iterator component = s.begin();

	// skip the first delim
	if ( find( component, s.end(), delim ) == s.begin() )
		component++;

	string::iterator nextDelim;
	while ( ( nextDelim = find( component, s.end(), delim ) ) != s.end() ) {
		components.push_back( string( component, nextDelim ) );
		component = nextDelim + 1;
	}
	if ( component != s.end() )
		components.push_back( string( component, s.end() ) );
		
	return &components;
}

void tokenizeString(const string& str, vector<string>& tokens, const string& delimiters = " ")
{
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type pos     = str.find_first_of(delimiters, lastPos);

	while (string::npos != pos || string::npos != lastPos)
	{
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(delimiters, pos);
		// Find next "non-delimiter"
		pos = str.find_first_of(delimiters, lastPos);
	}
}

void canonicalizePathname( string &path ) {
	char canonPath[PATH_MAX + 1];
	if( realpath( path.c_str(), canonPath ) != 0)
		path = canonPath;
}

void canonicalizePathname( string &path, const string &workingDirectory ) {
	string canonWD = workingDirectory;
	if( path[0] != '/' ) {
		canonicalizePathname( canonWD );
		path = canonWD + "/" + path;
	}

	canonicalizePathname( path );
}

