/*-
 * Point-to-point AltCodes<->koi8-r decoder with CR/LF translation
 *
 * Copyright (C) 1993-2003 by Andrey A. Chernov, Moscow, Russia
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef MSDOS
#define __MSDOS__
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#if defined(__MSDOS__) || defined(__OS2__)
#include <io.h>
#include <fcntl.h>
#define RB "rb"
#define WB "wb"
#else
#define RB "r"
#define WB "w"
#endif

#define TRUE  1
#define FALSE 0

#define NEEDSIZ 4096

#if BUFSIZ < NEEDSIZ
char inbuf[NEEDSIZ];
char outbuf[NEEDSIZ];
#endif

extern char *mktemp();
int RENAME(), decode();

#include "alt2koi8.h"
#include "koi82alt.h"
#include "win2koi8.h"
#include "koi82win.h"

char tmp_pat[] = "$1489_XXXXXX";
char tmp_name[256], out_name[256];
char **table;
char dos[] = "cp866(dos)";
char Unix[] = "koi8-r(unix)";
char win[] = "cp1251(win)";

logo(name)
char *name;
{
	fprintf(stderr, "Freeware %s v1.5\n\
Copyright (C) 1993-2003 by Andrey A. Chernov, Moscow, Russia\n", name);
}

char *basename(name)
char *name;
{
	char *p;

	if ((p = strrchr(name, '/')) != NULL)
		name = p + 1;
#if defined(__MSDOS__) || defined(__OS2__)
	if ((p = strrchr(name, '\\')) != NULL && p >= name)
		name = p + 1;
#endif
	return name;
}

int from_koi8, from_dos, binary = FALSE, verbose = FALSE, preserve = FALSE,
    unbuffered = FALSE;
char *outdir = "";

main(int ac, char **av)
{
	char *name, *tmpn, *srcn, *s, *incode, *outcode;
	FILE *fin, *fout;
	struct stat statb;
	int got_stat = FALSE;

	name = basename(av[0]);
#if defined(__MSDOS__) || defined(__OS2__)
	if ((s = strrchr(name, '.')) != NULL)
		*s = '\0';
	name = strlwr(name);
#endif
	if (strcmp(name, "fromdos") == 0) {
		from_koi8 = FALSE;
		from_dos = TRUE;
		table = alt2koi8;
		incode = dos;
		outcode = Unix;
	} else if (strcmp(name, "todos") == 0) {
		from_koi8 = TRUE;
		from_dos = FALSE;
		table = koi82alt;
		incode = Unix;
		outcode = dos;
	} else if (strcmp(name, "fromwin") == 0) {
		from_koi8 = FALSE;
		from_dos = FALSE;
		table = win2koi8;
		incode = win;
		outcode = Unix;
	} else if (strcmp(name, "towin") == 0) {
		from_koi8 = TRUE;
		from_dos = FALSE;
		table = koi82win;
		incode = Unix;
		outcode = win;
	} else {
		logo("todos");
		fprintf(stderr, "\nPut this program under the names fromdos,todos,fromwin,towin only\n");
		return 1;
	}

	while (   ac > 1
#if defined(__MSDOS__) || defined(__OS2__)
	       && (av[1][0] == '-' || av[1][0] == '/')
#else
	       && av[1][0] == '-'
#endif
	      ) {
		switch (tolower(av[1][1])) {
		case 'v':
			verbose = TRUE;
			ac--;
			av++;
			break;
		case 'b':
			binary = TRUE;
			ac--;
			av++;
			break;
		case 'p':
			preserve = TRUE;
			ac--;
			av++;
			break;
		case 'u':
			unbuffered = TRUE;
			ac--;
			av++;
			break;
		case 'o':
			ac--;
			av++;
			if (ac > 1) {
				outdir = av[1];
				if (*outdir) {
					s = outdir + strlen(outdir);
					while (   s > outdir + 1
					       &&
						  (s[-1] == '/'
#if defined(__MSDOS__) || defined(__OS2__)
						   || s[-1] == '\\'
#endif
						  )
					      )
						*(--s) = '\0';
				}
				av++;
				ac--;
				break;
			}
			/* fall through */
		case 'h':
		case '?':
			logo(name);
usage:
			fprintf(stderr, "\nUsage:\n\
    %s [-b] [-v] [-u] < %sTextFile > %sTextFile\n\
    %s [-b] [-v] [-u] [-p] [-o outdir] %sTextFile ...\n\
    %s [-h|-%s?]\n",
				name, incode, outcode,
				name, incode, name,
#ifdef unix
				"\\"
#else
				""
#endif
			       );
			fprintf(stderr,
"Options:\n\
    -h or -%s?:\tshort help (you see it)\n\
    -b:\t\tbinary mode, disable CR/LF translation\n\
    -p:\t\tpreserve modification times, if possible\n\
    -u:\t\tunbuffered mode\n\
    -v:\t\tverbose mode, some additional info\n\
    -o outdir:\tplace output file(s) into 'outdir' directory\n",
#ifdef unix
				"\\"
#else
				""
#endif
			       );
#if defined(__MSDOS__) || defined(__OS2__)
			fprintf(stderr,
"You can use '/' to indicate an option instead of '-' sign\n");
#endif
			return 1;
		default:
			logo(name);
			fprintf(stderr, "\n%s: unknown option\n", av[1]);
			goto usage;
		}
	}

	if (ac == 1) {
		if (*outdir) {
			fprintf(stderr, "-o doesn't make sense in this case\n");
			return 1;
		}
		if (preserve) {
			fprintf(stderr, "-p doesn't make sense in this case\n");
			return 1;
		}
		fin = stdin;
		fout = stdout;
#if defined(__MSDOS__) || defined(__OS2__)
		setmode(fileno(fin), O_BINARY);
		setmode(fileno(fout), O_BINARY);
#endif
		if (verbose)
			fprintf(stderr, "%s: decoding 'stdin' to 'stdout' in %s mode... ",
				name, binary ? "binary" : "text");
		if (!decode(fin, fout)) {
			perror("stdout");
			return 1;
		}
		if (verbose)
			fprintf(stderr, "Done.\n");
		return 0;
	}

	sprintf(tmp_name, "%s%s%s", outdir, *outdir ? "/" : "", tmp_pat);
	if ((tmpn = mktemp(tmp_name)) == NULL) {
		perror(tmp_name);
		return 1;
	}

	while (ac-- > 1) {
		srcn = av[1];
		av++;
		if (preserve && stat(srcn, &statb) >= 0)
			got_stat = TRUE;
		if ((fin = fopen(srcn, RB)) == NULL) {
			logo(name);
			fputc('\n', stderr);
			perror(srcn);
			goto usage;
		}
		if ((fout = fopen(tmpn, WB)) == NULL) {
			perror(tmpn);
			return 1;
		}
		if (*outdir) {
			sprintf(out_name, "%s/%s", outdir, basename(srcn));
			if (verbose)
				fprintf(stderr, "%s: decoding %s to %s in %s mode... ",
					name,
					srcn, out_name,
					binary ? "binary" : "text");
		}
		else if (verbose)
			fprintf(stderr, "%s: decoding %s in %s mode... ",
				name, srcn, binary ? "binary" : "text");
		if (!decode(fin, fout)) {
			perror(tmpn);
			unlink(tmpn);
			return 1;
		}
		if (*outdir)
			srcn = out_name;
		if (RENAME(tmpn, srcn) != 0) {
			perror(srcn);
			unlink(tmpn);
			return 1;
		}
		if (got_stat) {
			long ut[2];

			ut[0] = statb.st_atime;
			ut[1] = statb.st_mtime;
			utime(srcn, ut);
		}
		if (verbose)
			fprintf(stderr, "Done.\n");
	}
	return 0;
}

decode(fin, fout)
FILE *fin, *fout;
{
	register int c, SeeNext;
	static char cc[2];
	char *s;

	if (unbuffered) {
		setvbuf(fin, NULL, _IONBF, 0);
		setvbuf(fout, NULL, _IONBF, 0);
	}
#if BUFSIZ < NEEDSIZ
	else {
		setvbuf(fin, inbuf, _IOFBF, NEEDSIZ);
		setvbuf(fout, outbuf, _IOFBF, NEEDSIZ);
	}
#endif
	SeeNext = FALSE;
	while (   (c = getc(fin)) != EOF
	       && (binary || !from_dos || c != ('Z'&037))
	      ) {
		if (c & 0x80)
			s = table [c & 0x7F];
		else {
			s = "";
			goto single;
		}
		while (c = (unsigned char) *s++) {
		single:
			if (!binary) {
				if (SeeNext) {
					SeeNext = FALSE;
					if (c != '\n')
					      putc('\r', fout);
				}
				if (c == '\r') {
					SeeNext = TRUE;
					continue;
				}
				if (c == '\n' && from_koi8)
					putc('\r', fout);
			}
			putc(c, fout);
		}
	}
	fclose(fin);
	if (SeeNext)
		putc('\r', fout);

	return (fclose(fout) != EOF);
}

#ifdef NO_RENAME
int rename(old, new)
char *old, *new;
{
   unlink(new);
   return ((link(old, new) < 0 || unlink(old) < 0) ? -1 : 0);
}
#endif

int RENAME(oldname, newname)
char *oldname, *newname;
{
   FILE *of, *nf;
   int c;

   if (!rename( oldname, newname ))
	  return 0;

   if ((of = fopen(oldname, RB)) == NULL)
	   return -1;
   if ((nf = fopen(newname, WB)) == NULL) {
	   fclose(of);
	   return -1;
   }
#if BUFSIZ < NEEDSIZ
   setvbuf(of, inbuf, _IOFBF, NEEDSIZ);
   setvbuf(nf, outbuf, _IOFBF, NEEDSIZ);
#endif
   while ((c = getc(of)) != EOF) {
	   if (putc(c, nf) == EOF) {
			fclose(of);
			fclose(nf);
			unlink(newname);
			return -1;
	   }
   }
   fclose(of);
   if (fclose(nf) == EOF) {
	   unlink(newname);
	   return -1;
   }

   return (unlink(oldname) < 0 ? -1 : 0);

} /* RENAME */
