/* $Id: zip.h,v 1.3 2009/12/16 05:51:12 onoe Exp $ */

/*-
 * Copyright (c) 2005 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ZIP_H
#define	_ZIP_H

#ifdef NO_ATTRIBUTE
/* some compilers don't like it */
#define	__attribute__(x)
#endif

/*
 * Definition of ZIP
 */
struct zip_hdr {
	u_int8_t	zh_magic[4];	/* 'P', 'K', 3, 4 */
	u_int8_t	zh_reqver[2];	/* required version */
	u_int8_t	zh_flags[2];
	u_int8_t	zh_comp[2];	/* compression method */
	u_int8_t	zh_mtime[4];	/* last modified DOS time */
	u_int8_t	zh_crc32[4];
	u_int8_t	zh_csize[4];	/* compressed size */
	u_int8_t	zh_size[4];	/* uncompressed size */
	u_int8_t	zh_fnlen[2];	/* filename length */
	u_int8_t	zh_exlen[2];	/* extra field length */
} __attribute__((__packed__));

/* zh_magic */
#define	ZIP_MAGIC	0x04034b50

/* zh_flags */
#define	ZIP_ENCRYPTED	0x0001

/*
 * Definition of GZIP
 */
struct gzip_hdr {
	u_int8_t	gz_magic[2];
	u_int8_t	gz_method;
	u_int8_t	gz_flags;
	u_int8_t	gz_time[4];
	u_int8_t	gz_xflags;
	u_int8_t	gz_oscode;
} __attribute__((__packed__));

/* gz_magic */
#define	GZIP_MAGIC	0x8b1f

/* gz_flags */
#define	GZF_ASCII	0x01
#define	GZF_HDRCRC	0x02
#define	GZF_EXTRA	0x04
#define	GZF_NAME	0x08
#define	GZF_COMMENT	0x10

/*
 * Utility Macros
 */
#define	GET_LE2(p)	(((u_int8_t *)(p))[0] | (((u_int8_t *)(p))[1] << 8))
#define	GET_LE4(p)	(((u_int8_t *)(p))[0] | \
			 (((u_int8_t *)(p))[1] << 8) | \
			 (((u_int8_t *)(p))[2] << 16) | \
			 (((u_int8_t *)(p))[3] << 24))

#endif /* !_ZIP_H */
