/* $Id: tarfile.h,v 1.3 2004/02/26 09:11:31 onoe Exp $ */

/*-
 * Copyright (c) 1999 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <dirent.h>

#define	TARENTBLOCK	1024
#define	TARNMBLOCK	(TARENTBLOCK * 5)
#define	TARBSIZE	512
#define	TARNMSIZE	100
#define	TARZBUFSIZ	(TARBSIZE * 100)

struct tar_ent {
	char	*name;
	struct tar_file *file;
	int	off;
	int	size;	/* -1 means dir */
};

struct tar_name {
	struct tar_name *next;
	int	use;
	char	buf[TARNMBLOCK];
};

struct tar_dir {
	struct tar_dir *next;
	char	*name;
	int	namelen;
	int	nent;
	struct tar_dir *nextent;
	struct tar_ent	ent[TARENTBLOCK];
	struct tar_name nmbuf;
};

struct tar_file {
	struct tar_file	*next;
	char	*name;
	int	dirlen;
	int	size;
	time_t	mtime;
	ino_t	ino;
	void	*gz;
	int	have_index;
};

struct tar_dirp {
	DIR	*sysdir;
	struct tar_dir *tardir;
	int	tloc;
};

struct tar_fd {
	struct tar_ent *ent;
	int	pos;
};

struct tar_hdr {
	char	name[TARNMSIZE];
	char	mode[8];
	char	uid[8];
	char	gid[8];
	char	size[12];
	char	mtime[12];
	char	chksum[8];
	char	linkflag;
	char	linkname[TARNMSIZE];
};

int tar_addtgz(char *name);

DIR *tar_opendir(const char *filename);
struct dirent *tar_readdir(DIR *dirp);
int tar_closedir(DIR *dirp);

int tar_open(char *path);
int tar_stat(char *path, struct stat *stbuf);
int tar_fstat(int fd, struct stat *stbuf);
int tar_read(int fd, char *buf, int size);
int tar_close(int fd);
