/* $Id: asprintf.c,v 1.2 2004/02/27 04:25:42 onoe Exp $ */

/*-
 * Copyright (c) 2003 Atsushi Onoe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdarg.h>
#include <stdlib.h>

extern int vsnprintf(char *string, int n, const char *fmt, va_list ap);

int
vasprintf(char **ret, const char *fmt, va_list ap)
{
	int i, cnt, size;
	char *buf;
	char smallbuf[256];

	*ret = 0;
	buf = 0;
	cnt = vsnprintf(smallbuf, sizeof(smallbuf), fmt, ap);
	if (cnt < 0) 
		return cnt;
	if (cnt < sizeof(smallbuf)) {
		if ((*ret = malloc(cnt + 1)) == 0)
			cnt = -1;
		else {
			memcpy(*ret, smallbuf, cnt);
			(*ret)[cnt] = '\0';
		}
		return cnt;
	}
	if ((buf = malloc(cnt + 1)) == 0)
		return -1;
	cnt = vsnprintf(buf, cnt + 1, fmt, ap);
	if (cnt < 0)
		free(buf);
	else
		*ret = buf;
	return cnt;
}


int
asprintf(char **ret, const char *fmt, ...)
{
	int cnt;
	va_list ap;

	va_start(ap, fmt);
	cnt = vasprintf(ret, fmt, ap);
	va_end(ap);
	return cnt;
}
