/************************************
  copyright 2009

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "fieldsplit_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\nfieldsplit: splits a file into multiple files according to a particular field value.\n");
  fprintf(stderr, "\nusage: %s <options> [file ...] \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help               print this message and exit\n");
	fprintf(stderr, "  -V, --version            print version info and exit\n");
	fprintf(stderr, "  -f, --field <field>      index of field to split on\n");
	fprintf(stderr, "  -F, --field-label <field_label>\n                           label of field to split on\n");
	fprintf(stderr, "  -d, --delim <delim>      field separator string (default: 0xfe)\n");
	fprintf(stderr, "  -p, --path <path>        directory in which output files should be placed\n                           (default: ./)\n");
	fprintf(stderr, "  -n, --name <name>        output file prefix\n");
	fprintf(stderr, "  -s, --suffix <suffix>    output file suffix\n");
	fprintf(stderr, "  -k, --keep               preserve the input header row in all output files\n");
	fprintf(stderr, "  -S, --buffer-lines <buffer_line_count>\n                           line buffer size - DEPRECATED.\n");
	fprintf(stderr, "  -b, --buckets <buckets>  split data into BUCKETS files, guaranteeing that like\n                           field values are in the same output file.\n");
	fprintf(stderr, "  -x, --xform-names <xform_names>\n                           user-supplied substitution regex to transform output\n                           names (e.g. 's/[^-\w]//g')\n");
	fprintf(stderr, "\nEither -f or -F must be specified.");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"field", required_argument, 0, 'f'},
	{"field-label", required_argument, 0, 'F'},
	{"delim", required_argument, 0, 'd'},
	{"path", required_argument, 0, 'p'},
	{"name", required_argument, 0, 'n'},
	{"suffix", required_argument, 0, 's'},
	{"keep", no_argument, 0, 'k'},
	{"buffer-lines", required_argument, 0, 'S'},
	{"buckets", required_argument, 0, 'b'},
	{"xform-names", required_argument, 0, 'x'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVf:F:d:p:n:s:kS:b:x:", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'f':
				args->field = optarg;
				break;
			case 'F':
				args->field_label = optarg;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 'p':
				args->path = optarg;
				break;
			case 'n':
				args->name = optarg;
				break;
			case 's':
				args->suffix = optarg;
				break;
			case 'k':
				args->keep_header = 1;
				break;
			case 'S':
				args->buffer_line_count = optarg;
				break;
			case 'b':
				args->buckets = optarg;
				break;
			case 'x':
				args->xform_names = optarg;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

