/* This file is part of cqual.
   Copyright (C) 2000-2002 The Regents of the University of California.

cqual is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

cqual is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cqual; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include "common-AST.h"
#include "cstring.h"
#include "user-qual.h"


user_qual_list new_user_qual_list(user_qual qual,
				  user_qual_list next)
{
  user_qual_list nql = ralloc(parse_region, struct user_qual_list);
  nql->qual = qual;
  nql->next = next;
  return nql;
}

user_qual_list copy_user_qual_list(user_qual_list l)
{
  if (!l) return NULL;
  else return new_user_qual_list(l->qual, copy_user_qual_list(l->next));
}

/* Return TRUE if a textually identifier qualifier appears in l */
bool member_user_qual_list(user_qual_list l, char *q)
{
  for (; l; l = l->next)
    if (!strcmp(l->qual->cstring.data, q))
      return TRUE;
  return FALSE;
}

user_qual_list union_user_qual_list(user_qual_list left,
				    user_qual_list right)
{
  user_qual_list result = NULL;

  for (; left; left = left->next)
    {
      if (!member_user_qual_list(result, left->qual->cstring.data))
	result = new_user_qual_list(left->qual, result);
    }
  for (; right; right = right->next)
    {
      if (!member_user_qual_list(result, right->qual->cstring.data))
	result = new_user_qual_list(right->qual, result);
    }
  return result;
}

bool empty_user_qual_list(user_qual_list uql)
{
  return uql == NULL;
}
