/* This file is part of cqual.
   Copyright (C) 2003 The Regents of the University of California.

cqual is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

cqual is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cqual; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include "cqual.h"
#include "quals.h"
#include "effect.h"
#include "utils.h"
#include "qerror.h"
#include "color.h"

#ifndef GQTYPE_H
#define GQTYPE_H

/* Generic qualified type */
typedef struct Gqtype* gqtype;

/* Dispatch table for generic qualified types */
typedef struct Gqtype_dt* gqtype_dt;

/* Signatures for functions in dispatch tables */
typedef int (*pr_gqtype_qf_fn)(gqtype, printf_func, pr_qual_fn, qual_gate*, store, bool);
typedef int (*pr_gqtype_fn)(gqtype, printf_func, store);
typedef qual (*color_gqtype_fn)(gqtype, qual_gate *, store);

struct Gqtype {
  gqtype_dt dt;
};

struct Gqtype_dt {
  pr_gqtype_qf_fn print_gqtype_qf;
  pr_gqtype_fn print_gqtype;
  color_gqtype_fn color_gqtype;
};

/* Build a dispatch table */
gqtype_dt mk_gqtype_dt(region,
		       pr_gqtype_qf_fn, 
		       pr_gqtype_fn, 
		       color_gqtype_fn);

#endif /* GQTYPE_H */
