/* This file is part of cqual.
   Copyright (C) 2000-2003 The Regents of the University of California.

cqual is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

cqual is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cqual; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef CQUAL_H
#define CQUAL_H

#include "cqual-stdint.h"
#include "bitset.h"
#include "bool.h"
#include "buffer.h"
#include "regions.h"
#include "linkage.h"

EXTERN_C_BEGIN

/* Qualifiers and qualified types */
typedef struct Qtype *qtype;

/* Stores and effects */
typedef struct Abstract_loc *aloc;
typedef struct Effect *effect;
typedef struct Store *store;

/* Other */
typedef struct Rinfo *rinfo; /* Info for restrict */
typedef struct Drinfo *drinfo; /* Info for deep restrict */
typedef struct ExprDrinfoPair *exprdrinfo; /* Info for deep restrict */
typedef int (*printf_func)(const char *fmt, ...);

/* Polymorphism */
typedef enum {p_neg = -1, p_non = 0, p_pos = 1, p_sub = 2} polarity;
/* jf: p_sub can be used for standard flow */

/* Possible effect constructors */
typedef enum {
  eff_any = 0,
  eff_rwr,
  eff_r,
  eff_wr,
  eff_alloc,
  eff_last = eff_alloc } eff_kind;

/* Load in a lattice configuration file */
void load_config_file_quals(const char *);

/* If you use fail_loc, you must give a 3rd argument!  Pass 0 if you
   don't need anything there. */
#define fail_loc(l, s, args...) fail("(at %s:%ld) " s, ((l)->filename), ((l)->lineno), args)

/* If you use user_error_loc, you must give a 3rd argument!  Pass 0 if you
   don't need anything there. */
#define user_error_loc(l, s, args...) user_error("(at %s:%ld) " s, ((l)->filename), ((l)->lineno), args)

EXTERN_C_END

#endif
