/* libcqcam - shared Color Quickcam routines
 * Copyright (C) 1996-1998 by Patrick Reynolds
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_IMAGE_SIZE_H__
#define __GTK_IMAGE_SIZE_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif

#define GTK_IMAGE_SIZE(obj)          GTK_CHECK_CAST(obj, gtk_image_size_get_type(), GtkImageSize)
#define GTK_IMAGE_SIZE_CLASS(klass)  GTK_CHECK_CLASS_CAST(klass, gtk_image_size_get_type(), GtkImageSizeClass)
#define GTK_IS_IMAGE_SIZE(obj)       GTK_CHECK_TYPE(obj, gtk_image_size_get_type())

typedef struct _GtkImageSize       GtkImageSize;
typedef struct _GtkImageSizeClass  GtkImageSizeClass;

struct _GtkImageSize {
  GtkWidget widget;
  
  int max_width, max_height;
  int left, top, width, height;
  
  int handle, ox, oy;
};

struct _GtkImageSizeClass {
  GtkWidgetClass parent_class;
  
  void (*value_changed) (GtkImageSize *isz);
};

guint      gtk_image_size_get_type();
GtkWidget* gtk_image_size_new(int max_width, int max_height);
void       gtk_image_size_set_size(GtkImageSize *isz, int max_width, int max_height);
void       gtk_image_size_set(GtkImageSize *isz, int left, int top, int width, int height);
void       gtk_image_size_get(GtkImageSize *isz, int *left, int *top, int *width, int *height);

#ifdef __cplusplus
}
#endif

#endif
