#ifndef __OBFUSCATE_H__
#define __OBFUSCATE_H__

/*!
 \file     obfuscate.h
 \author   Trevor Williams  (trevorw@charter.net)
 \date     9/16/2006
 \brief    Contains functions for internal obfuscation.
*/


/*!
 Used for obfuscating signal names.  Improves performance when obfuscation mode is not turned on.
*/
#define obf_sig(x) (obf_mode ? obfuscate_name(x,'s') : x)

/*!
 Used for obfuscating functional unit names.  Improves performance when obfuscation mode is not
 turned on.
*/
#define obf_funit(x) (obf_mode ? obfuscate_name(x,'f') : x)

/*!
 Used for obfuscating file names.  Improves performance when obfuscation mode is not turned on.
*/
#define obf_file(x) (obf_mode ? obfuscate_name(x,'v') : x)

/*!
 Used for obfuscating instance names.  Improves performance when obfuscation mode is not turned on.
*/
#define obf_inst(x) (obf_mode ? obfuscate_name(x,'i') : x)


extern bool obf_mode;


/*! \brief Sets the global 'obf_mode' variable to the specified value */
void obfuscate_set_mode( bool value );

/*! \brief Gets an obfuscated name for the given actual name */
char* obfuscate_name( char* real_name, char prefix );

/*! \brief Deallocates all memory associated with obfuscation */
void obfuscate_dealloc();


/*
 $Log: obfuscate.h,v $
 Revision 1.4  2006/08/18 22:19:54  phase1geo
 Fully integrated obfuscation into the development release.

 Revision 1.3  2006/08/18 22:07:45  phase1geo
 Integrating obfuscation into all user-viewable output.  Verified that these
 changes have not made an impact on regressions.  Also improved performance
 impact of not obfuscating output.

 Revision 1.1.2.2  2006/08/18 04:50:51  phase1geo
 First swag at integrating name obfuscation for all output (with the exception
 of CDD output).

 Revision 1.1.2.1  2006/08/17 04:17:38  phase1geo
 Adding files to obfuscate actual names when outputting any user-visible
 information.
*/

#endif
